import PropTypes from 'prop-types';
import React, {Component} from 'react';
import classnames from 'classnames';

export default class PasswordField extends Component {
    render() {
        const {
            isIE,
            isMobile,
            passwordType,
            passwordIsEmpty,
            errors,
            refBind,
            notify,
            togglePasswordEmptyState,
            togglePasswordType,
            showLoginField,
            inputLogin,
            login
        } = this.props;

        const passwordEyeClassnames = {
            'password-eye': true,
            'password-eye__hidden': passwordType === 'text'
        };

        const loginHiddenStyle = {
            display: 'none'
        };

        const passwordInputClassnames = {
            'passport-Input': true,
            'passport-Input_empty': isIE && passwordIsEmpty
        };

        const passwordFieldClassnames = {
            'passport-Domik-Form-Field': true,
            'passport-Domik-Form-Field_with_toggle': Boolean(isMobile),
            'passport-Domik-Form-Field-State_error':
                ['password.not_matched', 'password.empty'].indexOf(errors) > -1 &&
                this.passwordInput &&
                this.passwordInput.value === ''
        };

        return (
            <div className={classnames(passwordFieldClassnames)}>
                {Boolean(isMobile) && (
                    <span className={classnames(passwordEyeClassnames)} onClick={togglePasswordType} />
                )}
                <label className={classnames(passwordInputClassnames)}>
                    {Boolean(!showLoginField) && (
                        <input
                            autoComplete='username'
                            name='login'
                            readOnly={true}
                            style={loginHiddenStyle}
                            type='text'
                            value={inputLogin || login}
                        />
                    )}

                    <input
                        className='passport-Input-Controller'
                        name='passwd'
                        type={passwordType}
                        autoCorrect='off'
                        autoCapitalize='off'
                        autoComplete={passwordType === 'password' ? 'current-password' : 'off'}
                        placeholder=' '
                        onChange={notify}
                        onInput={togglePasswordEmptyState}
                        ref={refBind}
                    />
                    <span className='passport-Input-View'>
                        <span className='passport-Input-Label'>{i18n('OneDomik.Form.Label.Password')}</span>
                    </span>
                </label>
            </div>
        );
    }
}

PasswordField.propTypes = {
    notify: PropTypes.func.isRequired,
    togglePasswordEmptyState: PropTypes.func.isRequired,
    togglePasswordType: PropTypes.func.isRequired,
    errors: PropTypes.string,
    inputLogin: PropTypes.string,
    isIE: PropTypes.bool,
    isMobile: PropTypes.bool,
    login: PropTypes.string,
    passwordIsEmpty: PropTypes.bool,
    passwordType: PropTypes.string,
    refBind: PropTypes.func,
    showLoginField: PropTypes.bool
};
