import PropTypes from 'prop-types';
import React, {Component} from 'react';

export default class SubmitField extends Component {
    render() {
        const {intranet, formIsSubmitted, allowedAuthMethods, switchToMagic} = this.props;

        return (
            <div className='passport-Domik-Form-Field'>
                <button disabled={formIsSubmitted} type='submit' className='passport-Button'>
                    <span className='passport-Button-Content'>
                        <span className='passport-Button-Text'>{i18n('_AUTH_.Form.ButtonText.login')}</span>
                    </span>
                </button>
                {Boolean(
                    !intranet &&
                        (!allowedAuthMethods || (allowedAuthMethods && allowedAuthMethods.indexOf('magic') > -1))
                ) && (
                    <button onClick={switchToMagic} type='button' className='passport-Button passport-Button_qr'>
                        <span className='passport-Button-Content' />
                    </button>
                )}
            </div>
        );
    }
}

SubmitField.propTypes = {
    intranet: PropTypes.bool,
    formIsSubmitted: PropTypes.bool,
    allowedAuthMethods: PropTypes.array,
    switchToMagic: PropTypes.func
};
