import PropTypes from 'prop-types';
import React, {Component} from 'react';
import magic from '../magic/index.js';
import LoginField from './fieldComponents/LoginField/LoginField.jsx';
import PasswordField from './fieldComponents/PasswordField/PasswordField.jsx';
import CaptchaField from './fieldComponents/CaptchaField/CaptchaField.jsx';
import PolicyField from './fieldComponents/PolicyField/PolicyField.jsx';
import SubmitField from './fieldComponents/SubmitField/SubmitField.jsx';
import MagicField from './fieldComponents/MagicField/MagicField.jsx';
import OTPField from './fieldComponents/OTPField/OTPField.jsx';
import RfcTOTPField from './fieldComponents/RfcTOTPField/RfcTOTPField.jsx';

import {
    domikIsLoading,
    switchPasswordType,
    switchLoginEmptyState,
    switchPasswordEmptyState,
    switchFormSubmittedState,
    submitIframeCheck,
    switchToMagic,
    switchCaptchaEmptyState
} from '../actions';
import {notifyOfLoginChange, notifyOfPasswordChange, notifyOfCaptchaChange} from './actions.js';
import metrics from '../../metrics';
import {connect} from 'react-redux';
import {bindActionCreators} from 'redux';
import assign from 'lodash/assign';

function mapDispatchToProps(dispatch) {
    const actionCreators = {
        notifyOfLoginChange,
        notifyOfPasswordChange,
        notifyOfCaptchaChange,
        domikIsLoading,
        submitIframeCheck,
        switchPasswordType,
        switchLoginEmptyState,
        switchPasswordEmptyState,
        switchToMagic,
        switchFormSubmittedState,
        switchCaptchaEmptyState
    };

    return assign(bindActionCreators(actionCreators, dispatch), {dispatch});
}

function mapStateToProps(state) {
    const {
        authorizedAccounts,
        captchaRequired,
        embAnswer,
        // focused,
        form,
        submitCounter,
        loginIsEmpty,
        passwordIsEmpty,
        captchaIsEmpty,
        formIsSubmitted,
        formIsUpgraded,
        passwordType,
        processedAccount,
        inputLogins
    } = state.one_domik;

    const {clean, track_id, csrf, fretpath, from, loginStatusRetpath, pane, retpath} = state.common;

    const errors = state.errors.code;

    const captcha = state.captcha;

    const {isMobile, isTablet} = state.settings.ua;

    const isIE = ['MSIE', 'Edge'].indexOf(state.settings.ua.BrowserName) > -1;
    const inputLogin = (processedAccount && inputLogins && inputLogins[processedAccount.uid]) || null;

    const {lang, intranet} = state.settings;

    const formSettings = {
        target: '_self',
        handle: state.common.auth_url,
        retpath
    };

    if (formIsUpgraded) {
        formSettings.target = 'iframe';
        formSettings.handle = state.common.embeddedauth_url;
        formSettings.retpath = `${loginStatusRetpath}`;
    }

    return {
        allowedAuthMethods: processedAccount && processedAccount.allowed_auth_methods,
        captchaIsEmpty,
        captcha,
        captchaRequired,
        csrf,
        errors,
        focused: true,
        form,
        formIsSubmitted,
        formSettings,
        inputLogin,
        isIE,
        isMobile,
        isMobileCaptcha: Boolean(isMobile || isTablet),
        intranet,
        lang,
        loginIsEmpty,
        passwordIsEmpty,
        login: processedAccount && (processedAccount.displayLogin || processedAccount.login),
        passwordType,
        pane,
        realRetpath: retpath,
        retpath: loginStatusRetpath,
        showPolicyTick: !intranet && authorizedAccounts.length === 0,
        submitCounter,
        track_id: (embAnswer && embAnswer.idkey) || track_id,
        from,
        fretpath,
        clean
    };
}

class Form extends Component {
    constructor(props) {
        super(props);
        this.passwordFocus = this.passwordFocus.bind(this);
        this.captchaFocus = this.captchaFocus.bind(this);
        this.loginFocus = this.loginFocus.bind(this);

        this.togglePasswordType = this.togglePasswordType.bind(this);
        this.toggleLoginEmptyState = this.toggleLoginEmptyState.bind(this);
        this.togglePasswordEmptyState = this.togglePasswordEmptyState.bind(this);
        this.toggleCaptchaEmptyState = this.toggleCaptchaEmptyState.bind(this);

        this.sendMetrics = this.sendMetrics.bind(this);
        this.onSubmit = this.onSubmit.bind(this);

        this.loginBind = this.bindRef('loginInput').bind(this);
        this.passwordBind = this.bindRef('passwordInput').bind(this);
        this.captchaBind = this.bindRef('captchaInput').bind(this);
    }

    bindRef(ref) {
        const self = this;

        return function(input) {
            self[ref] = input;
        };
    }

    sendMetrics(params) {
        metrics.send(params);
    }

    onSubmit() {
        metrics.send([
            this.props.showLoginField ? 'Экран пустого домика' : 'Экран саджеста',
            'Отправка формы авторизации'
        ]);

        if (this.props.passwordType === 'text') {
            this.togglePasswordType();
        }

        this.props.dispatch(domikIsLoading(true));
        this.props.dispatch(switchFormSubmittedState(true));

        return true;
    }

    togglePasswordType() {
        this.props.dispatch(switchPasswordType(this.props.passwordType === 'text' ? 'password' : 'text'));
    }

    toggleLoginEmptyState() {
        this.props.dispatch(switchLoginEmptyState(this.loginInput.value === ''));
    }

    togglePasswordEmptyState() {
        this.props.dispatch(switchPasswordEmptyState(this.passwordInput.value === ''));
    }

    toggleCaptchaEmptyState() {
        this.props.dispatch(switchCaptchaEmptyState(this.captchaInput.value === ''));
    }

    componentDidMount() {
        this.props.submitIframeCheck();

        if (this.props.method === 'magic') {
            magic.start();
        }

        if (this.loginInput) {
            if (this.props.form.login) {
                this.loginInput.value = this.props.form.login;
            }

            this.toggleLoginEmptyState();
        }

        if (this.passwordInput) {
            this.togglePasswordEmptyState();
        }

        if (this.captchaInput) {
            this.toggleCaptchaEmptyState();
        }

        if (this.loginInput && this.props.focused) {
            this.loginFocus();
        }

        if (!this.loginInput && this.props.method !== 'magic' && this.props.focused) {
            this.passwordFocus();
        }
    }

    componentDidUpdate(prevProps) {
        if (this.props.method === 'magic') {
            if (prevProps.track_id !== this.props.track_id) {
                magic.restart();
            }
        }

        if (!this.props.errors && prevProps.focused !== this.props.focused) {
            if (!this.props.method) {
                this.loginFocus();
            } else {
                this.passwordFocus();
            }
        }

        if (['login.empty', 'account.not_found'].indexOf(this.props.errors) > -1) {
            this.loginFocus();
        }

        if (
            ['password.not_matched', 'password.not_matched_2fa', 'rfc_otp.invalid', 'password.empty'].indexOf(
                this.props.errors
            ) > -1
        ) {
            if (this.props.submitCounter !== prevProps.submitCounter) {
                this.passwordInput.value = '';
                this.props.dispatch(switchPasswordEmptyState(true));
                this.passwordFocus();
            }
        }

        if (['captcha.required', 'captcha.invalid'].indexOf(this.props.errors) > -1) {
            if (this.props.submitCounter !== prevProps.submitCounter) {
                this.captchaInput.value = '';
                this.props.dispatch(switchCaptchaEmptyState(true));
                this.captchaFocus();
            }
        }
    }

    componentWillUnmount() {
        if (this.props.method === 'magic') {
            magic.stop();
        }
    }

    passwordFocus() {
        setTimeout(() => this.passwordInput && this.passwordInput.focus(), 0);
    }

    captchaFocus() {
        setTimeout(() => this.captchaInput && this.captchaInput.focus(), 0);
    }

    loginFocus() {
        setTimeout(() => this.loginInput && this.loginInput.focus(), 0);
    }

    render() {
        const {
            allowedAuthMethods,
            captcha,
            captchaIsEmpty,
            captchaRequired,
            clean,
            csrf,
            dispatch,
            errors,
            form,
            formIsSubmitted,
            formSettings,
            fretpath,
            from,
            inputLogin,
            isIE,
            isMobile,
            isMobileCaptcha,
            isPhoneNumberExperiment,
            intranet,
            lang,
            login,
            loginIsEmpty,
            method,
            notifyOfLoginChange,
            notifyOfPasswordChange,
            notifyOfCaptchaChange,
            passwordIsEmpty,
            passwordType,
            realRetpath,
            // rfc,
            showLoginField,
            showPolicyTick,
            switchToMagic,
            track_id // eslint-disable-line
        } = this.props;

        return (
            <form
                method='post'
                target={formSettings.target}
                action={formSettings.handle}
                onSubmit={this.onSubmit}
                className='passport-Domik-Form'
            >
                <input type='hidden' name='real_retpath' value={realRetpath} />
                <input type='hidden' name='from' value={from} />
                <input type='hidden' name='fretpath' value={fretpath} />
                <input type='hidden' name='clean' value={clean} />
                <input type='hidden' name='idkey' value={track_id} />
                <input type='hidden' name='csrf_token' value={csrf} />
                <input type='hidden' name='one' value='1' />
                <input type='hidden' name='extended' value='1' />

                {Boolean(formSettings.retpath) && <input type='hidden' name='retpath' value={formSettings.retpath} />}

                {Boolean(form.pdd_domain) && <input type='hidden' name='pdd_domain' value={form.pdd_domain} />}

                {!showLoginField && <input type='hidden' name='source' value={method} />}

                {Boolean(showLoginField) && (
                    <LoginField
                        toggleLoginEmptyState={this.toggleLoginEmptyState}
                        errors={errors}
                        isIE={isIE}
                        refBind={this.loginBind}
                        notify={notifyOfLoginChange}
                        loginIsEmpty={loginIsEmpty}
                        isPhoneNumberExperiment={Boolean(isPhoneNumberExperiment)}
                    />
                )}

                {track_id && method === 'magic' && <MagicField trackId={track_id} />}

                {(method === 'otp' || method === 'magic') && (
                    <OTPField
                        togglePasswordEmptyState={this.togglePasswordEmptyState}
                        togglePasswordType={this.togglePasswordType}
                        errors={errors}
                        inputLogin={inputLogin}
                        isIE={isIE}
                        isMobile={isMobile}
                        login={login}
                        passwordIsEmpty={passwordIsEmpty}
                        passwordType={passwordType}
                        refBind={this.passwordBind}
                        notify={notifyOfPasswordChange}
                        showLoginField={showLoginField}
                    />
                )}

                {method === 'rfc_totp' && (
                    <RfcTOTPField
                        togglePasswordEmptyState={this.togglePasswordEmptyState}
                        togglePasswordType={this.togglePasswordType}
                        errors={errors}
                        inputLogin={inputLogin}
                        isIE={isIE}
                        isMobile={isMobile}
                        login={login}
                        passwordIsEmpty={passwordIsEmpty}
                        passwordType={passwordType}
                        refBind={this.passwordBind}
                        notify={notifyOfPasswordChange}
                        showLoginField={showLoginField}
                    />
                )}

                {method !== 'otp' && method !== 'rfc_totp' && method !== 'magic' && (
                    <PasswordField
                        togglePasswordEmptyState={this.togglePasswordEmptyState}
                        togglePasswordType={this.togglePasswordType}
                        errors={errors}
                        inputLogin={inputLogin}
                        isIE={isIE}
                        isMobile={isMobile}
                        login={login}
                        passwordIsEmpty={passwordIsEmpty}
                        passwordType={passwordType}
                        refBind={this.passwordBind}
                        notify={notifyOfPasswordChange}
                        showLoginField={showLoginField}
                    />
                )}

                {captchaRequired && (
                    <CaptchaField
                        isIE={isIE}
                        captchaIsEmpty={captchaIsEmpty}
                        toggleCaptchaEmptyState={this.toggleCaptchaEmptyState}
                        errors={errors}
                        isMobileCaptcha={isMobileCaptcha}
                        lang={lang}
                        captcha={captcha}
                        refBind={this.captchaBind}
                        notify={notifyOfCaptchaChange}
                        dispatch={dispatch}
                    />
                )}

                {Boolean(showPolicyTick) && <PolicyField />}

                <SubmitField
                    allowedAuthMethods={allowedAuthMethods}
                    formIsSubmitted={formIsSubmitted}
                    intranet={intranet}
                    switchToMagic={switchToMagic}
                />
            </form>
        );
    }
}

export default connect(mapStateToProps, mapDispatchToProps)(Form);

Form.propTypes = {
    allowedAuthMethods: PropTypes.arrayOf(PropTypes.string),
    captcha: PropTypes.object,
    captchaRequired: PropTypes.bool,
    errors: PropTypes.string,
    csrf: PropTypes.string,
    form: PropTypes.object,
    formSettings: PropTypes.object,
    isMobile: PropTypes.bool,
    isMobileCaptcha: PropTypes.bool,
    isIE: PropTypes.bool,
    inputLogin: PropTypes.string,
    login: PropTypes.string,
    loginIsEmpty: PropTypes.bool,
    passwordIsEmpty: PropTypes.bool,
    captchaIsEmpty: PropTypes.bool,
    rfc: PropTypes.bool,
    focused: PropTypes.bool,
    method: PropTypes.string.isRequired,
    retpath: PropTypes.string,
    realRetpath: PropTypes.string,
    formIsSubmitted: PropTypes.bool,
    fretpath: PropTypes.string,
    from: PropTypes.string,
    clean: PropTypes.string,
    passwordType: PropTypes.string,
    showPolicyTick: PropTypes.bool,
    switchToMagic: PropTypes.func,
    track_id: PropTypes.string,
    updateCaptchaValue: PropTypes.func,
    updateLoginValue: PropTypes.func,
    dispatch: PropTypes.func,
    submitCounter: PropTypes.number,
    updatePasswordValue: PropTypes.func,
    submitIframeCheck: PropTypes.func,
    notifyOfLoginChange: PropTypes.func,
    notifyOfPasswordChange: PropTypes.func,
    notifyOfCaptchaChange: PropTypes.func,
    showLoginField: PropTypes.bool,
    isPhoneNumberExperiment: PropTypes.bool,
    intranet: PropTypes.bool,
    lang: PropTypes.string
};
