import assign from 'lodash/assign';
import React from 'react';
import PropTypes from 'prop-types';
import Pane from '../pane.jsx';
import {connect} from 'react-redux';
import {bindActionCreators} from 'redux';
import AccountList from '../account_list/account_list.jsx';
import {switchModeToAddingAccount} from '../actions';

function mapDispatchToProps(dispatch) {
    const actionCreators = {
        switchModeToAddingAccount
    };

    return assign(bindActionCreators(actionCreators, dispatch), {dispatch});
}

function mapStateToProps(state) {
    const {isTouch} = state.settings.ua;

    return {
        isTouch
    };
}

class List extends React.Component {
    render() {
        const props = this.props;

        return (
            <Pane>
                <AccountList
                    isTouch={props.isTouch}
                    onMouseDown={this.sendMetrics}
                    switchLinkOnclick={() => props.switchModeToAddingAccount(true)}
                />
            </Pane>
        );
    }
}

List.propTypes = {
    isTouch: PropTypes.bool,
    switchModeToAddingAccount: PropTypes.func
};

export default connect(mapStateToProps, mapDispatchToProps)(List);
