import PropTypes from 'prop-types';
import React, {Component} from 'react';
import {connect} from 'react-redux';

import Pane from '../pane.jsx';
import MagicField from '../form/fieldComponents/MagicField/MagicField.jsx';
import Errors from '../errors/errors.jsx';

import magic from './index.js';
import actions from './actions.js';
import select from './select.js';

export class Magic extends Component {
    constructor(props) {
        super(props);

        this.switch = props.switch;
        this.onClick = this.onClick.bind(this);
        this.markup = this.getMarkup(props);
    }

    componentDidMount() {
        magic.start();
    }

    getMarkup(props) {
        const {tld, isTouch} = props;

        let appLinkDomain = ['com', 'co.il', 'fr'].indexOf(tld) > -1 ? 'com' : 'ru';

        if (tld === 'com.tr') {
            appLinkDomain = 'com.tr';
        }

        const strings = {
            header1: i18n('OneDomik.Magic.header.1'),
            header2: i18n('OneDomik.Magic.header.2'),
            header3: i18n('OneDomik.Magic.header.3'),
            linkTouch: 'https://mobile.yandex.ru/apps/key',
            linkDesktop: `https://yandex.${appLinkDomain}/support/passport/authorization/twofa.html`
        };

        const keyLink = `<a class='passport-Domik-Link' href='${isTouch ? strings.linkTouch : strings.linkDesktop}'>${
            strings.header2
        }</a>`;

        const intro = `${strings.header1.replace('%s', keyLink)}${strings.header3}`;

        return {
            __html: intro
        };
    }

    componentDidUpdate(prevProps) {
        if (prevProps.magicCSRFToken !== this.props.magicCSRFToken) {
            magic.restart();
            return;
        }

        if (prevProps.trackId !== this.props.trackId) {
            magic.restart();
            return;
        }
    }

    componentWillUnmount() {
        magic.stop();
    }

    onClick(e) {
        e.preventDefault();
        this.switch();
    }

    render() {
        return (
            <Pane>
                <h2 className='passport-Domik-Title'>
                    <span className='passport-Domik-Title-Part' dangerouslySetInnerHTML={this.markup} />
                </h2>

                <Errors />

                <MagicField trackId={this.props.trackId} />

                <div>
                    {i18n('OneDomik.Magic.footer.1')}{' '}
                    <a href='' className='passport-Domik-Link' onClick={this.onClick}>
                        {i18n('OneDomik.Magic.footer.2')}
                    </a>
                </div>
            </Pane>
        );
    }
}

Magic.propTypes = {
    tld: PropTypes.string.isRequired,
    trackId: PropTypes.string.isRequired,
    magicCSRFToken: PropTypes.string.isRequired,
    isTouch: PropTypes.bool.isRequired,
    switch: PropTypes.func.isRequired
};

const ConnectedMagic = connect(select, actions)(Magic);

export default ConnectedMagic;
