import {switchModeToAddingAccount, showAccounts, showMagicError, reAuthPasswordSubmit} from '../actions';

let store;
const magicWrapper = {
    init(s) {
        store = s;
    },

    onSuccess(message) {
        let state;

        if (message.origin !== location.origin) {
            return;
        }

        if (message.data.socialAuth) {
            state = store.getState();

            if (state.common.retpath) {
                redirect(state.common.retpath);
            } else {
                store.dispatch(showAccounts());
            }
        }
    },

    start(params) {
        this.restart(params);
    },

    restart() {
        const self = this;
        const state = store.getState();

        self.track_id = state.common.track_id;
        self.csrf_token = state.common.magic_csrf_token;

        self.stop();

        self._interval = 300;

        window.intervalTimeout = setTimeout(function() {
            self._interval = 1000;
        }, 60 * 1000);

        window.redirectTimeout = setTimeout(function() {
            window.location.reload(true);
        }, 60 * 1000 * 10);

        self._stopped = false;
        self.restartPolling();
    },

    restartPolling() {
        const self = this;

        if (!self._stopped) {
            setTimeout(function() {
                self.poll();
            }, self._interval);
        }
    },

    poll() {
        const self = this;
        const req = $.ajax('/auth/new/magic/status/', {
            data: {
                track_id: self.track_id,
                csrf_token: self.csrf_token
            },
            dataType: 'json',
            type: 'POST'
        });

        req.done(function(results) {
            let error;

            if (results.status === 'ok' && results.state === 'otp_auth_finished') {
                window.location.href = `/auth/finish/?track_id=${self.track_id}`;
                return;
            }

            if (results.errors) {
                error = results.errors[0];

                if (error === 'password.not_matched') {
                    error = 'password.not_matched_2fa';
                }

                if (error === 'captcha.required') {
                    self.stop();
                    store.dispatch(switchModeToAddingAccount());
                    store.dispatch(showMagicError(error));

                    return;
                }

                if (['internal.temporary', 'backend.redis_failed'].indexOf(error) === -1) {
                    store.dispatch(showMagicError(error));
                    store.dispatch(reAuthPasswordSubmit());
                    self.stop();
                }
            }

            self.restartPolling();
        });
    },

    stopPoll() {
        this._stopped = true;
    },

    stop() {
        clearTimeout(window.intervalTimeout);
        clearTimeout(window.redirectTimeout);

        this.stopPoll();
    }
};

function redirect(url) {
    const form = document.createElement('form');
    const element1 = document.createElement('input');

    form.method = 'GET';
    form.action = '/redirect';

    element1.value = url;
    element1.name = 'url';
    form.appendChild(element1);

    document.body.appendChild(form);

    form.submit();
    form.parentNode.removeChild(form);
}

export default magicWrapper;
