import {createSelector} from 'reselect';

import {selectCommon, selectSettings} from '../selectors.js';

const select = createSelector(selectCommon, selectSettings, (common, settings) => {
    const {
        tld,
        ua: {isTouch}
    } = settings;

    const {track_id: trackId, magic_csrf_token: magicCSRFToken} = common;

    return {
        tld,
        isTouch,
        trackId,
        magicCSRFToken
    };
});

export default select;
