import PropTypes from 'prop-types';
import React, {Component} from 'react';
import {bindActionCreators} from 'redux';
import assign from 'lodash/assign';
import {connect} from 'react-redux';
import {
    doModeAnimation,
    switchModeToAddingAccount,
    switchModeToEdit,
    switchToMagic,
    updateLoginValue,
    updatePasswordValue,
    updateCaptchaValue,
    submitIframeCheck,
    ONE_DOMIK_GOAL_PREFIX
} from './actions';
import {startSocialAuth} from './broker';
// import {ConnectedAccountList} from './account_list/account_list.jsx';
// import {SocialBlock, ExtendedSocialBlock} from './social/social.jsx';
// import {Magic} from './magic/magic.jsx';
// import {Form} from './form/form.jsx';
// import {Errors} from './errors/errors.jsx';
// import {CurrentAccount} from './current_account/current_account.jsx';
// import {SwitchLink} from './switch/switch.jsx';
import metrics from '../metrics';
function mapDispatchToProps(dispatch) {
    const actionCreators = {
        doModeAnimation,
        switchModeToAddingAccount,
        switchModeToEdit,
        switchToMagic,
        startSocialAuth,
        updatePasswordValue,
        updateLoginValue,
        updateCaptchaValue,
        submitIframeCheck
    };

    return assign(bindActionCreators(actionCreators, dispatch), {dispatch});
}

function mapStateToProps(state) {
    const {
        authorizedAccounts,
        captchaRequired,
        csrf_token,
        embAnswer,
        focused,
        form,
        submitCounter,
        isExpanded,
        loading,
        loginIsEmpty,
        passwordIsEmpty,
        captchaIsEmpty,
        formIsSubmitted,
        formIsUpgraded,
        passwordType,
        suggestedAccounts,
        track_id,
        processedAccount,
        mode,
        method,
        defaultAccount,
        inputLogin,
        unitedAccounts
    } = state.one_domik;

    const {
        backpath,
        clean,
        csrf,
        experiments,
        fretpath,
        from,
        embeddedauth_url,
        editUrl,
        auth_url,
        pane,
        loginStatusRetpath,
        registration_url,
        restoration_url,
        retpath,
        yandex_url
    } = state.common;

    const {socialExtended, socialScope, tagline, display, minimal} = state.customs;

    const additionalDataRequestState = Boolean(state.additionalDataRequest.state);

    const captcha = state.captcha;

    const {isTouch, isMobile} = state.settings.ua;

    const isIE = ['MSIE', 'Edge'].indexOf(state.settings.ua.BrowserName) > -1;

    const {avatar, tld, lang, intranet} = state.settings;

    const formSettings = {
        target: '_self',
        handle: state.common.auth_url,
        retpath
    };

    if (formIsUpgraded) {
        formSettings.target = 'iframe';
        formSettings.handle = state.common.embeddedauth_url;
        formSettings.retpath = `${loginStatusRetpath}?method=${method}`;
    }

    return {
        additionalDataRequestState,
        account: defaultAccount,
        authorizedAccounts,
        avatar,
        backpath,
        clean,
        captcha,
        captchaIsEmpty,
        captchaRequired,
        csrf,
        csrf_token,
        embAnswer,
        editUrl,
        auth_url,
        embeddedauth_url,
        flagsString: experiments.flagsString,
        focused,
        form,
        formSettings,
        formIsSubmitted,
        fretpath,
        from,
        inputLogin,
        isExpanded,
        isIE,
        isMobile,
        isTouch,
        intranet,
        lang,
        loading,
        loginIsEmpty,
        loginStatusRetpath,
        method,
        minimal,
        mode,
        pane,
        passwordIsEmpty,
        passwordType,
        processedAccount,
        registration_url,
        restoration_url,
        retpath,
        socialExtended,
        socialScope,
        submitCounter,
        suggestedAccounts,
        display,
        tagline,
        tld,
        track_id,
        unitedAccounts,
        yandex_url
    };
}

class OneDomik extends Component {
    constructor(props) {
        super(props);

        this.sendMetrics = this.sendMetrics.bind(this);
        // this.backClickHandler = this.backClickHandler.bind(this);
    }

    // backClickHandler(e) {
    //     e.preventDefault();

    //     if (this.props.mode === 'magic') {
    //         this.props.switchModeToAddingAccount(true);
    //     } else {
    //         this.props.switchModeToEdit();
    //     }
    // }

    sendMetrics(event) {
        const visitParams = event.currentTarget.dataset.metrics;

        let metricsHeader = 'Экран пустого домика';

        if (this.props.pane === '/auth/welcome') {
            metricsHeader = 'Экран саджеста';
        }

        if (this.props.pane === '/auth/list') {
            metricsHeader = 'Экран списка саджестов';
        }

        if (visitParams) {
            metrics.send([metricsHeader, visitParams]);
        }
    }

    componentDidMount() {
        const pane = this.props.pane;
        const authorizedAccounts = this.props.authorizedAccounts || [];
        const suggestedAccounts = this.props.suggestedAccounts || [];
        const unitedAccounts = this.props.unitedAccounts || {};

        if (this.props.flagsString) {
            metrics.goal(this.props.flagsString);
        }

        if (pane === '/auth/add' || pane === '/auth') {
            if (!this.props.processedAccount) {
                metrics.send(['Экран пустого домика', 'Показ']);
                metrics.goal(`${ONE_DOMIK_GOAL_PREFIX}_show_empty_form`);
            }
        }

        if (pane === '/auth/welcome') {
            metrics.send([
                'Экран саджеста',
                'Показ',
                {
                    method: this.props.method
                }
            ]);
            metrics.goal(`${ONE_DOMIK_GOAL_PREFIX}_show_suggest`);
        }

        if (pane === '/auth/list') {
            metrics.send([
                'Экран списка саджестов',
                'Показ списка саджестов',
                {
                    authorized: authorizedAccounts.length,
                    suggested: suggestedAccounts.length,
                    united: Object.keys(unitedAccounts).length
                }
            ]);

            if (!authorizedAccounts.length) {
                metrics.goal(`${ONE_DOMIK_GOAL_PREFIX}_show_only_suggests_list`);
            }

            if (authorizedAccounts.length) {
                metrics.goal(`${ONE_DOMIK_GOAL_PREFIX}_show_accounts_list`);
            }
        }
    }

    render() {
        const props = this.props;

        return (
            <div
                className={
                    // eslint-disable-next-line max-len
                    `passport-ScreenBox passport-Domik-Content passport-Domik-Content_wide passport-ScreenBox_${props.mode}`
                }
            >
                <div className='passport-ScreenBox-Content'>{props.children}</div>

                {Boolean(!props.intranet && !props.additionalDataRequestState) && (
                    <ul className='passport-Domik-Footer'>
                        <li className='passport-Domik-Footer-Item'>
                            {props.processedAccount && props.mode === 'addingAccount' ? (
                                <a
                                    data-metrics='Клик на восстановление'
                                    onMouseDown={this.sendMetrics}
                                    href={props.restoration_url}
                                    className='passport-Domik-Link passport-Domik-Footer-Link'
                                >
                                    {i18n('OneDomik.Footer.Link.RestorePassword')}
                                </a>
                            ) : (
                                <a
                                    data-metrics='Клик на восстановление'
                                    onMouseDown={this.sendMetrics}
                                    href={props.restoration_url}
                                    className='passport-Domik-Link passport-Domik-Footer-Link'
                                >
                                    {i18n('OneDomik.Footer.Link.Restoration')}
                                </a>
                            )}
                        </li>

                        {Boolean(!props.minimal) && (
                            <li className='passport-Domik-Footer-Item'>
                                <a
                                    data-metrics='Клик на регистрацию'
                                    onMouseDown={this.sendMetrics}
                                    href={props.registration_url}
                                    className='passport-Domik-Link passport-Domik-Footer-Link'
                                >
                                    {i18n('OneDomik.Footer.Link.Registration')}
                                </a>
                            </li>
                        )}
                    </ul>
                )}

                <iframe className='passport-Domik-Iframe' name='iframe' src='about:blank' />
            </div>
        );
    }
}

OneDomik.propTypes = {
    account: PropTypes.object,
    authorizedAccounts: PropTypes.arrayOf(PropTypes.object),
    avatar: PropTypes.object,
    captcha: PropTypes.object,
    captchaRequired: PropTypes.bool,
    csrf_token: PropTypes.string,
    embAnswer: PropTypes.object,
    flagsString: PropTypes.string,
    form: PropTypes.object,
    embeddedauth_url: PropTypes.string,
    auth_url: PropTypes.string,
    intranet: PropTypes.bool,
    isExpanded: PropTypes.bool,
    isMobile: PropTypes.bool,
    isTouch: PropTypes.bool,
    lang: PropTypes.string,
    loading: PropTypes.bool,
    loginStatusRetpath: PropTypes.string,
    method: PropTypes.string,
    mode: PropTypes.string,
    processedAccount: PropTypes.object,
    registration_url: PropTypes.string,
    restoration_url: PropTypes.string,
    retpath: PropTypes.string,
    socialExtended: PropTypes.bool,
    switchModeToAddingAccount: PropTypes.func,
    switchModeToEdit: PropTypes.func,
    submitIframeCheck: PropTypes.func,
    suggestedAccounts: PropTypes.arrayOf(PropTypes.object),
    display: PropTypes.string,
    minimal: PropTypes.bool,
    track_id: PropTypes.string,
    unitedAccounts: PropTypes.object,
    yandex_url: PropTypes.string,
    pane: PropTypes.string,
    children: PropTypes.node.isRequired,
    additionalDataRequestState: PropTypes.bool
};

const ConnectedOneDomik = connect(mapStateToProps, mapDispatchToProps)(OneDomik);

export default ConnectedOneDomik;
