import React from 'react';
import PropTypes from 'prop-types';
import classnames from 'classnames';

export default class Pane extends React.Component {
    constructor(props) {
        super(props);

        this.cnames = Object.assign(
            {},
            {
                'passport-ScreenBox-Item': true,
                'passport-ScreenBox-Item_current': true
            },
            props.cnames
        );
    }

    render() {
        const cnames = this.cnames;

        return (
            <div className={classnames(cnames)}>
                <div className='passport-ScreenBox-Item-Content'>
                    <div className='passport-Domik-Content'>{this.props.children}</div>
                </div>
            </div>
        );
    }
}

Pane.propTypes = {
    children: PropTypes.node.isRequired,
    cnames: PropTypes.object
};
