import {createSelector} from 'reselect';

export const selectOneDomik = (state) => state.one_domik;
export const selectCommon = (state) => state.common;
export const selectSettings = (state) => state.settings;
export const selectErrors = (state) => state.errors;

export const selectFormSettings = createSelector(selectOneDomik, selectCommon, selectSettings, (oneDomik, common) => {
    const {auth_url: handle, retpath, loginStatusRetpath, embeddedauth_url} = common;

    const formSettings = {
        target: '_self',
        handle,
        retpath
    };

    if (oneDomik.formIsUpgraded) {
        formSettings.target = 'iframe';
        formSettings.handle = embeddedauth_url;
        formSettings.retpath = loginStatusRetpath;
    }

    return formSettings;
});
