import PropTypes from 'prop-types';
import React, {Component} from 'react';
const CLS_NAME = 'passport-Domik-SocialNetworks';

const networks = {
    social_gg: {
        provider: 'gg',
        name: i18n('OneDomik.SocialBlock.BigButton.common').replace('%s', i18n('_AUTH_.SocialBlock.BigButton.gg'))
    },
    social_tw: {
        provider: 'tw',
        name: i18n('OneDomik.SocialBlock.BigButton.common').replace('%s', i18n('_AUTH_.SocialBlock.BigButton.tw'))
    },
    social_fb: {
        provider: 'fb',
        name: i18n('OneDomik.SocialBlock.BigButton.common').replace('%s', i18n('_AUTH_.SocialBlock.BigButton.fb'))
    },
    social_mr: {
        provider: 'mr',
        name: i18n('OneDomik.SocialBlock.BigButton.common').replace('%s', i18n('_AUTH_.SocialBlock.BigButton.mr'))
    },
    social_vk: {
        provider: 'vk',
        name: i18n('OneDomik.SocialBlock.BigButton.common').replace('%s', i18n('_AUTH_.SocialBlock.BigButton.vk'))
    },
    social_ok: {
        provider: 'ok',
        name: i18n('OneDomik.SocialBlock.BigButton.common').replace('%s', i18n('_AUTH_.SocialBlock.BigButton.ok'))
    }
};

class SocialBlockBigButton extends Component {
    render() {
        const {name, provider, onMouseDown, onClick} = this.props;

        return (
            <li className={`${CLS_NAME}-Field`}>
                <button
                    tabIndex='0'
                    data-metrics={`Начало соцавторизации: ${provider}`}
                    onMouseDown={onMouseDown}
                    onClick={onClick}
                    type='button'
                    className={`passport-Button passport-Button_${provider}`}
                >
                    <span className='passport-Button-Content'>
                        <span className='passport-Button-After'>
                            <span className={`passport-Icon passport-Icon_social_${provider}`} />
                        </span>

                        <span className='passport-Button-Text'>{name}</span>
                    </span>
                </button>
            </li>
        );
    }
}

export class ExtendedSocialBlock extends Component {
    render() {
        const {providers, showInfo, onMouseDown, socialScope, startSocialAuth} = this.props;

        const enabled = providers.filter((item) => item.enabled);
        const big = enabled.filter((item) => item.primary);
        const small = enabled.filter((item) => !item.primary);

        return (
            <div>
                {showInfo && <h3 className='passport-Domik-Title'>{i18n('OneDomik.SocialBlock.title')}</h3>}

                <ul className={CLS_NAME}>
                    {
                        // Object.keys(networks).map((item) =>
                        // <SocialBlockBigButton
                        //     onClick={() => startSocialAuth(networks[item].provider)}
                        //     key={networks[item].provider}
                        //     {...networks[item]}/>
                        // )
                    }
                    {big.map((item) => (
                        <SocialBlockBigButton
                            onClick={() =>
                                startSocialAuth({
                                    provider: item.data.code,
                                    scope: socialScope && socialScope[item.data.code]
                                })
                            }
                            onMouseDown={onMouseDown}
                            key={item.data.code}
                            {...networks[`social_${item.data.code}`]}
                        />
                    ))}
                    {small.map((item) => (
                        <li key={item.data.code} className={`${CLS_NAME}-Item-h`}>
                            <button
                                data-metrics={`Начало соцавторизации: ${item.data.code}`}
                                onMouseDown={onMouseDown}
                                onClick={() =>
                                    startSocialAuth({
                                        provider: item.data.code,
                                        scope: socialScope && socialScope[item.data.code]
                                    })
                                }
                                tabIndex='0'
                                role='button'
                                className={`${CLS_NAME}-Item ${CLS_NAME}-Item_${item.data.code}`}
                            >
                                <span className={`passport-Icon passport-Icon_social_${item.data.code}`} />
                            </button>
                        </li>
                    ))}
                </ul>
            </div>
        );
    }
}
export class SocialBlock extends Component {
    render() {
        const {method, providers, showInfo, socialScope, onMouseDown, startSocialAuth} = this.props;

        const preferred = [networks[method]];
        const enabled = providers.filter((item) => item.enabled);

        return (
            <div>
                {showInfo && <h3 className='passport-Domik-Title'>{i18n('OneDomik.SocialBlock.title')}</h3>}

                <ul className={CLS_NAME}>
                    {method && preferred
                        ? preferred.map((item) => (
                              <SocialBlockBigButton
                                  onClick={() =>
                                      startSocialAuth({
                                          provider: item.provider,
                                          scope: socialScope && socialScope[item.provider]
                                      })
                                  }
                                  onMouseDown={onMouseDown}
                                  key={item.provider}
                                  {...item}
                              />
                          ))
                        : enabled.map((item) => (
                              <li key={item.data.code} className={`${CLS_NAME}-Item-h`}>
                                  <button
                                      data-metrics={`Начало соцавторизации: ${item.data.code}`}
                                      onMouseDown={onMouseDown}
                                      onClick={() =>
                                          startSocialAuth({
                                              provider: item.data.code,
                                              scope: socialScope && socialScope[item.data.code]
                                          })
                                      }
                                      tabIndex='0'
                                      role='button'
                                      className={`${CLS_NAME}-Item ${CLS_NAME}-Item_${item.data.code}`}
                                  >
                                      <span className={`passport-Icon passport-Icon_social_${item.data.code}`} />
                                  </button>
                              </li>
                          ))}
                </ul>
            </div>
        );
    }
}

SocialBlock.propTypes = {
    method: PropTypes.string,
    showInfo: PropTypes.bool,
    providers: PropTypes.array,
    socialScope: PropTypes.object,
    startSocialAuth: PropTypes.func,
    onMouseDown: PropTypes.func
};

SocialBlockBigButton.propTypes = {
    name: PropTypes.string,
    onClick: PropTypes.func,
    onMouseDown: PropTypes.func,
    provider: PropTypes.string
};

ExtendedSocialBlock.propTypes = {
    providers: PropTypes.array,
    showInfo: PropTypes.bool,
    onMouseDown: PropTypes.func,
    socialScope: PropTypes.object,
    startSocialAuth: PropTypes.func
};
