import PropTypes from 'prop-types';
import React, {Component} from 'react';

export class SwitchLink extends Component {
    constructor(props) {
        super(props);

        this.clickHandler = this.clickHandler.bind(this);
    }

    clickHandler(e) {
        e.preventDefault();
        this.props.onClick();
    }

    render() {
        const {linkText, fallbackUrl, onMouseDown} = this.props;

        if (!linkText) {
            return null;
        }

        return (
            <span className='passport-Domik-Account-Item'>
                <a
                    href={fallbackUrl}
                    onClick={this.clickHandler}
                    onMouseDown={onMouseDown}
                    data-metrics='Клик на Другой аккаунт'
                    className='passport-Domik-Account-Link passport-Domik-Link'
                >
                    {linkText}
                </a>
            </span>
        );
    }
}

export class SwitchModeToAddLink extends Component {
    constructor(props) {
        super(props);

        this.clickHandler = this.clickHandler.bind(this);
    }

    clickHandler(e) {
        e.preventDefault();
        this.props.onClick();
    }

    render() {
        const {linkText, onMouseDown, addUserUrl} = this.props;

        if (!linkText) {
            return null;
        }

        return (
            <li className='passport-AccountList-Item passport-false passport-false_adding'>
                <a
                    data-metrics='Клик на Другой аккаунт'
                    onMouseDown={onMouseDown}
                    onClick={this.clickHandler}
                    href={addUserUrl}
                    className='passport-AccountList-Link'
                >
                    <span className='passport-AccountList-Userpic passport-Userpic'>
                        <span className='passport-Icon passport-Icon_adding'>
                            <span className='passport-Icon-Helper1' />
                            <span className='passport-Icon-Helper2' />
                        </span>
                    </span>
                    <span className='passport-AccountList-Text'>{linkText}</span>
                </a>
            </li>
        );
    }
}

SwitchLink.propTypes = {
    fallbackUrl: PropTypes.string,
    linkText: PropTypes.string,
    onClick: PropTypes.func,
    onMouseDown: PropTypes.func
};

SwitchModeToAddLink.propTypes = {
    addUserUrl: PropTypes.string,
    linkText: PropTypes.string,
    onClick: PropTypes.func,
    onMouseDown: PropTypes.func
};
