import assign from 'lodash/assign';
import React from 'react';
import PropTypes from 'prop-types';
import {CurrentAccount} from '../current_account/current_account.jsx';
import {SwitchLink} from '../switch/switch.jsx';
import Errors from '../errors/errors.jsx';
import Form from '../form/form.jsx';
import {SocialBlock} from '../social/social.jsx';
import Pane from '../pane.jsx';
import {connect} from 'react-redux';
import {bindActionCreators} from 'redux';
import {switchModeToAddingAccount, switchModeToEdit} from '../actions';
import {startSocialAuth} from '../broker';

import {setupBackPane} from '../../common/actions';

function mapDispatchToProps(dispatch) {
    const actionCreators = {
        startSocialAuth,
        switchModeToAddingAccount,
        switchModeToEdit
    };

    return assign(bindActionCreators(actionCreators, dispatch), {dispatch});
}

function mapStateToProps(state) {
    const {isExpanded, processedAccount, unitedAccounts} = state.one_domik;

    const {socialScope} = state.customs;

    const providers = state.social.providers;

    const {avatar} = state.settings;

    const {editUrl, addUserUrl} = state.common;

    const method = (processedAccount && processedAccount.preferred_auth_method) || 'password';

    return {
        addUserUrl,
        avatar,
        editUrl,
        isExpanded,
        method,
        processedAccount,
        providers,
        socialScope,
        unitedAccounts
    };
}

class Welcome extends React.Component {
    componentDidMount() {
        if (Object.keys(this.props.unitedAccounts).length) {
            this.props.dispatch(setupBackPane(this.props.editUrl));
        }
    }

    render() {
        const {
            addUserUrl,
            avatar,
            editUrl,
            method,
            processedAccount,
            providers,
            socialScope,
            startSocialAuth,
            switchModeToAddingAccount,
            switchModeToEdit,
            unitedAccounts
        } = this.props;
        const formMethods = ['password', 'otp', 'magic', 'magic_link'];

        return (
            <Pane>
                <CurrentAccount account={processedAccount} avatar={avatar} />

                {Boolean(Object.keys(unitedAccounts).length > 1) && (
                    <SwitchLink
                        onMouseDown={this.sendMetrics}
                        onClick={() => switchModeToEdit()}
                        fallbackUrl={editUrl}
                        linkText={i18n('OneDomik.ChooseOtherAccount.link')}
                    />
                )}

                {Boolean(Object.keys(unitedAccounts).length === 1) && (
                    <SwitchLink
                        onMouseDown={this.sendMetrics}
                        onClick={() => switchModeToAddingAccount(true)}
                        fallbackUrl={addUserUrl}
                        linkText={i18n('OneDomik.OtherAccount.link')}
                    />
                )}

                <Errors />

                {formMethods.indexOf(method) !== -1 && <Form method={method} showLoginField={false} />}

                {Boolean(
                    ['social_gg', 'social_fb', 'social_tw', 'social_mr', 'social_vk', 'social_ok'].indexOf(method) > -1
                ) && (
                    <div>
                        {Boolean(
                            processedAccount.allowed_auth_methods &&
                                processedAccount.allowed_auth_methods.indexOf('password') > -1
                        ) && <Form method={'password'} showLoginField={false} />}

                        <SocialBlock
                            showInfo={false}
                            startSocialAuth={startSocialAuth}
                            onMouseDown={this.sendMetrics}
                            socialScope={socialScope}
                            providers={providers}
                            method={method}
                        />
                    </div>
                )}
            </Pane>
        );
    }
}

Welcome.propTypes = {
    avatar: PropTypes.object,
    isExpanded: PropTypes.bool,
    method: PropTypes.string,
    editUrl: PropTypes.string,
    addUserUrl: PropTypes.string,
    processedAccount: PropTypes.object,
    providers: PropTypes.array,
    socialScope: PropTypes.object,
    unitedAccounts: PropTypes.object,
    startSocialAuth: PropTypes.func,
    switchModeToEdit: PropTypes.func,
    switchModeToAddingAccount: PropTypes.func,
    dispatch: PropTypes.func
};

export default connect(mapStateToProps, mapDispatchToProps)(Welcome);
