import React, {useEffect} from 'react';
import PropTypes from 'prop-types';
import {connect} from 'react-redux';
import {Route, Switch, withRouter} from 'react-router-dom';

import {Layout} from './components/Layout';
import AnimatedLayer from './components/AnimatedLayer/AnimatedLayer.jsx';
import PageVisibilityLayer from './components/PageVisibilityLayer/PageVisibilityLayer.jsx';

import getRoutes from './routes';

import './App.styl';

const App = ({location, history, isAmDebugPageEnabled, isWebView, version}) => {
    const actualRoutes = getRoutes({isAmDebugPageEnabled, isWebView, version});

    useEffect(() => {
        if (isWebView && window.yaPassportLoaded && typeof window.yaPassportLoaded === 'function') {
            const callback = () => window.yaPassportLoaded({status: 'ok', version});

            callback();
            const interval = setInterval(() => {
                callback();
            }, 2000);

            return () => clearInterval(interval);
        }
    }, [isWebView, version]);

    return (
        <Layout location={location}>
            <PageVisibilityLayer />

            <AnimatedLayer location={location} history={history}>
                <Switch location={location}>
                    {actualRoutes.map((route) => (
                        <Route key={route.path} {...route} />
                    ))}
                </Switch>
            </AnimatedLayer>
        </Layout>
    );
};

function mapStateToProps(state) {
    const {am = {}, common = {}, settings = {}} = state;

    return {
        isAmDebugPageEnabled: am.isAm && am.debug,
        isWebView: common.isWebView,
        version: settings.version
    };
}

App.propTypes = {
    location: PropTypes.shape({
        key: PropTypes.string,
        pathname: PropTypes.string.isRequired
    }).isRequired,
    history: PropTypes.shape({
        action: PropTypes.string.isRequired
    }).isRequired,
    isAmDebugPageEnabled: PropTypes.bool,
    isWebView: PropTypes.bool,
    version: PropTypes.string
};

export default withRouter(connect(mapStateToProps)(App));
