import api from '../../api';
import {updateCSRF} from '../../common/actions';
import {push} from 'connected-react-router';
import redirectToRetpath from './redirectToRetpath';
import showAccounts from './showAccounts';
import {initAdditionalDataRequest, setupBackPane} from './';
import {hasExp} from '@blocks/selectors';

export default function additionalDataAsk() {
    return (dispatch, getState) => {
        const state = getState();
        const {common = {}, am = {}} = state;
        const {askEmailUrl, askPhoneUrl, askAvatarUrl, profileSecurityWithCustoms, origin} = common;
        const securityExp = hasExp(state, 'dozapros-weak-password-exp');

        if (am.isAm) {
            return dispatch(redirectToRetpath());
        }

        api.request('auth/accounts', {origin})
            .done((res) => {
                const params = {
                    csrf_token: res.csrf,
                    uid: res.accounts.defaultAccount && res.accounts.defaultAccount.uid
                };

                dispatch(updateCSRF(res.csrf));

                api.request('auth/additional_data/ask_v2', params)
                    .done((payload = {}) => {
                        const {state, action, track_id: trackId} = payload;

                        dispatch(initAdditionalDataRequest(payload));
                        dispatch(setupBackPane(null));

                        if (state === 'password' && action === 'weak' && securityExp) {
                            return location.replace(`${profileSecurityWithCustoms}&track_id=${trackId}`);
                        }

                        if (state === 'phone') {
                            dispatch(showAccounts());
                            dispatch(push(askPhoneUrl));
                            return;
                        }

                        if (state === 'email') {
                            dispatch(showAccounts());
                            dispatch(push(askEmailUrl));
                            return;
                        }

                        if (state === 'avatar') {
                            dispatch(showAccounts());
                            dispatch(push(askAvatarUrl));
                            return;
                        }

                        dispatch(redirectToRetpath());
                    })
                    .fail(() => {
                        dispatch(redirectToRetpath());
                    });
            })
            .fail(() => {
                dispatch(redirectToRetpath());
            });
    };
}
