export const CLEAR_ERRORS = 'CLEAR_ERRORS';
export const SET_ERRORS = 'SET_ERRORS';

export const CHANGE_CAPTCHA_ANSWER = 'CHANGE_CAPTCHA_ANSWER';
export const CHANGE_CAPTCHA_STATE = 'CHANGE_CAPTCHA_STATE';
export const CHANGE_PHONE_NUMBER = 'CHANGE_PHONE_NUMBER';
export const CHANGE_EMAIL = 'CHANGE_EMAIL';
export const CHANGE_CONFIRMATION_CODE = 'CHANGE_CONFIRMATION_CODE';
export const CHANGE_CONFIRMATION_CODE_SENT_STATUS = 'CHANGE_CONFIRMATION_CODE_SENT_STATUS';
export const SENT_PHONE_CONFIRMATION_CODE_SUCCESS = 'SENT_PHONE_CONFIRMATION_CODE_SUCCESS';
export const SENT_EMAIL_CONFIRMATION_CODE_SUCCESS = 'SENT_EMAIL_CONFIRMATION_CODE_SUCCESS';

export function clearErrors() {
    return {
        type: CLEAR_ERRORS
    };
}

export function setErrors(errors) {
    return {
        type: SET_ERRORS,
        errors
    };
}

export function changeCaptchaAnswer(captchaAnswer) {
    return {
        type: CHANGE_CAPTCHA_ANSWER,
        captchaAnswer
    };
}

export function changeCaptchaState(isCaptchaRequired) {
    return {
        type: CHANGE_CAPTCHA_STATE,
        isCaptchaRequired
    };
}

export function changePhoneNumber(phoneNumber) {
    return {
        type: CHANGE_PHONE_NUMBER,
        phoneNumber
    };
}

export function changeEmail(email) {
    return {
        type: CHANGE_EMAIL,
        email
    };
}

export function changeConfirmationCode(confirmationCode) {
    return {
        type: CHANGE_CONFIRMATION_CODE,
        confirmationCode
    };
}

export function changeConfirmationCodeSentStatus(isConfirmationCodeSent) {
    return {
        type: CHANGE_CONFIRMATION_CODE_SENT_STATUS,
        isConfirmationCodeSent
    };
}

export function sentPhoneConfirmationCodeSuccess(payload) {
    return {
        type: SENT_PHONE_CONFIRMATION_CODE_SUCCESS,
        payload
    };
}

export function sentEmailConfirmationCodeSuccess() {
    return {
        type: SENT_EMAIL_CONFIRMATION_CODE_SUCCESS
    };
}
