import api from '../../api';
import {clearErrors, setErrors} from './additionalDataRequestActions';
import skipAdditionalData from './skipAdditionalData';
import redirectToPasswordRequest from './redirectToPasswordRequest';
import sendAdditionalDataRequestMetrics from './sendAdditionalDataRequestMetrics';
import {domikIsLoading} from './';

export default function approveActualPhone(phoneId) {
    return (dispatch, getState) => {
        const {
            settings: {language},
            common: {csrf}
        } = getState();

        const params = {
            csrf_token: csrf,
            phone_id: phoneId,
            display_language: language
        };

        dispatch(clearErrors());

        api.request('phone/manage/prolong_valid_v2', params)
            .done(() => {
                dispatch(
                    sendAdditionalDataRequestMetrics(
                        'approve_actual_phone',
                        'Показ актуализации телефона',
                        'Актуализация номера'
                    )
                );
                dispatch(skipAdditionalData('no'));
            })
            .fail((error) => {
                if (error.errors.indexOf('password.required') !== -1) {
                    dispatch(redirectToPasswordRequest());
                    return;
                }

                dispatch(setErrors(error.errors));
                dispatch(domikIsLoading(false));
            });
    };
}
