import api from '@blocks/api';
import {getLanguage, getTrackId, getFormValues, getRedirectUrl, isAndroidAm} from '@blocks/selectors';
import {changePagePopupType, changePagePopupVisibility, domikIsLoading} from '@blocks/authv2/actions';
import {updateErrors} from '@blocks/actions/form';
import sendToChallenge from '@blocks/authv2/actions/challenge/sendToChallenge';
import {SUCCESS_AUTH_SMS, SUCCESS_AUTH_GOAL} from '@blocks/authv2/metrics_constants';
import {
    setPhoneConfirmationDenyResendUntilTime,
    updatePhoneNumber,
    setPhoneConfirmationInternationalPhoneNumber
} from '@blocks/actions/phoneConfirm';
import {Platforms} from '@blocks/authv2/nativeMobileApi/constants';
import {amRequestSmsCode, amSetAnalyticsToRetpath} from '@blocks/authv2/actions/nativeMobileApi';
import {getError} from '@blocks/utils';
import metrics from '@blocks/metrics';

export const FIELD_NAME = 'phoneCode';
const MODE = 'tracked';

export const SET_AUTH_BY_SMS_STATE = 'SET_AUTH_BY_SMS_STATE';

export const setAuthBySMSState = (payload = {phone: '', denyResendUntil: ''}) => ({
    type: SET_AUTH_BY_SMS_STATE,
    payload
});

export const submitAuthBySMS = () => (dispatch, getState) => {
    const state = getState();
    const {am = {}} = state;

    const requestParams = {
        trackId: getTrackId(state, 'common'),
        language: getLanguage(state),
        mode: MODE
    };

    if (am.isAm && am.platform === Platforms.ANDROID) {
        requestParams.gpsPackageName = am.appId;
    }

    if (!isAndroidAm(state)) {
        requestParams.isCodeWithFormat = true;
    }

    dispatch(domikIsLoading(true));

    api.requestPhoneConfirmationCode(requestParams)
        .then((response = {}) => {
            const {denyResendUntil, phone, internationalPhoneNumber} = response;

            dispatch(setPhoneConfirmationDenyResendUntilTime(denyResendUntil));
            dispatch(updatePhoneNumber(phone));
            dispatch(setPhoneConfirmationInternationalPhoneNumber(internationalPhoneNumber));
            dispatch(setAuthBySMSState({error: ''}));
            dispatch(changePagePopupVisibility(true));
            dispatch(changePagePopupType('authConfirmationBySMS'));
            dispatch(domikIsLoading(false));
            dispatch(amRequestSmsCode());
        })
        .catch((error = {}) => {
            const {errors = []} = error;
            const code = errors[0] || 'global';

            dispatch(setAuthBySMSState({error: code}));
            dispatch(domikIsLoading(false));
        });
};

export const commitAuthBySMS = () => (dispatch, getState) => {
    const state = getState();
    const code = getFormValues(state)[FIELD_NAME];
    const trackId = getTrackId(state, 'common');
    const {am = {}} = state;

    let redirectUrl = getRedirectUrl(state);

    if (am.isAm) {
        dispatch(amSetAnalyticsToRetpath('auth_by_sms'));
        redirectUrl = getRedirectUrl(getState());
    }

    dispatch(domikIsLoading(true));

    const errorCallback = (error = {}) => {
        const {errors = []} = error;
        const code = errors[0] || 'global';

        dispatch(updateErrors({field: FIELD_NAME, error: code ? getError(FIELD_NAME, code) : {}}));
        dispatch(domikIsLoading(false));
    };

    api.checkPhoneConfirmationCode({trackId, mode: MODE, code})
        .then((response = {}) => {
            const {status} = response;

            if (status === 'ok') {
                return api
                    .multiStepCommitSMSCode({trackId, retpath: redirectUrl})
                    .then((commitResponse = {}) => {
                        const {status, redirectUrl: redirectUrlFromResponse, state, retpath} = commitResponse;

                        if (status === 'ok') {
                            if (state === 'auth_challenge') {
                                dispatch(domikIsLoading(false));
                                dispatch(sendToChallenge());
                                return;
                            }

                            const handleFinish = () => {
                                if (state && redirectUrlFromResponse) {
                                    return (window.location = redirectUrlFromResponse);
                                }

                                metrics.goal(SUCCESS_AUTH_GOAL);
                                metrics.send([SUCCESS_AUTH_SMS]);

                                return (window.location = retpath || redirectUrl);
                            };

                            if (am.isAm) {
                                dispatch(domikIsLoading(false));

                                // В интеграции веб ам есть нативный спиннер
                                // чтобы они не пересекались с вебным, нужно
                                // скрыть вебный и дать реакту отрисовать его скрытие
                                return setTimeout(() => {
                                    handleFinish();
                                });
                            }

                            return handleFinish();
                        }

                        errorCallback(commitResponse);
                    })
                    .catch(errorCallback);
            }

            errorCallback(response);
        })
        .catch(errorCallback);
};
