import metrics from '@blocks/metrics';
import {getTrackId, getFormValues} from '@blocks/selectors';
import {changePagePopupType, changePagePopupVisibility} from '@blocks/authv2/actions';
import {TRACK_TYPES} from '@blocks/actions/tracks';
import {amRequestOTP} from '@blocks/authv2/actions/nativeMobileApi';
import {setCaptchaTrack} from '@components/Captcha/actions';
import api from '@blocks/api';

async function request(url, params) {
    try {
        return await api.request(url, params);
    } catch (error) {
        if (error && Array.isArray(error.errors)) {
            return error;
        }

        throw error;
    }
}

function waitOTPResult(getState) {
    return new Promise((resolve) => {
        const intervalId = setInterval(() => {
            const state = getState();
            const {otp} = getFormValues(state);

            if (otp) {
                clearInterval(intervalId);
                resolve(otp);
            }
        }, 100);
    });
}

function failHandler(state) {
    const {am} = state;

    metrics.send(['Ключ с картинкой', 'Завершение с ошибкой']);

    window.location = am.finishErrorUrl;
}

export function authEnableKey2FA() {
    return async (dispatch, getState) => {
        const state = getState();
        const trackId = getTrackId(state, TRACK_TYPES.COMMON);

        await api.updateCsrfToken();

        const submitResult = await request('/auth/otp/enable/submit', {track_id: trackId});

        if (submitResult.status !== 'ok') {
            throw failHandler(state);
        }

        const secretResult = await request('/auth/otp/enable/get-secret', {track_id: trackId});

        if (secretResult.status !== 'ok' || !secretResult.app_secret || !secretResult.pin) {
            throw failHandler(state);
        }

        await dispatch(amRequestOTP({secret: secretResult.app_secret, pin: secretResult.pin}));
        const otp = await waitOTPResult(getState);

        const checkResult = await request('/auth/otp/enable/check-otp', {otp, track_id: trackId});

        if (checkResult.status !== 'ok') {
            throw failHandler(state);
        }

        const commitResult = await request('/auth/otp/enable/commit', {track_id: trackId});

        if (commitResult.status !== 'ok') {
            if (Array.isArray(commitResult.errors) && commitResult.errors[0] === 'captcha.required') {
                dispatch(setCaptchaTrack(trackId));
                dispatch(changePagePopupType('captcha'));
                dispatch(changePagePopupVisibility(true));

                throw commitResult;
            }

            throw failHandler(state);
        }

        metrics.send(['Ключ с картинкой', 'Успешный вход']);
    };
}
