import api from '../../api';
import {updateMagicTokensSuccess, domikIsLoading} from './';
import showAccounts from './showAccounts';

export default function authPasswordSubmitForMagic() {
    return function(dispatch, getState) {
        const {
            common: {profile_url: profileUrl, retpath, fretpath, clean, origin}
        } = getState();
        const params = {
            retpath: retpath || profileUrl,
            fretpath,
            clean,
            origin,
            with_code: 1
        };

        dispatch(domikIsLoading(true));

        api.request('auth/password/submit', params)
            .done((response) => {
                const {track_id: trackId, csrf_token: magicCSRF} = response;

                // Магия стартует в componentDidUpdate после установки трека
                // и magicCSRF
                dispatch(updateMagicTokensSuccess(trackId, magicCSRF));
            })
            .fail(() => {
                dispatch(showAccounts());
            })
            .always(() => dispatch(domikIsLoading(false)));
    };
}
