import api from '../../../api';
import commitChallenge from './commitChallenge';
import handleError from './handleError';
import {domikIsLoading} from '../';
import {setChallengeError} from './index';
import userValidateCommit from '@blocks/UserValidate/actions/userValidateCommit';
import metrics from '../../../metrics';
import {
    CHALLENGES_PAGE,
    CHALLENGES_PAGE_PHONE_CALL_SUCCESS,
    CHALLENGES_PAGE_PHONE_CALL_ERROR
} from '../../metrics_constants';

export default function checkCode() {
    return (dispatch, getState) => {
        const {
            challenge: {fieldValue, isStandAloneChallenge},
            common: {track_id: trackId, csrf},
            form: {values} = {}
        } = getState();
        const code = fieldValue || values.phoneCode;
        const params = {
            code,
            track_id: trackId,
            csrf_token: csrf
        };

        dispatch(domikIsLoading(true));
        dispatch(
            setChallengeError({
                code: '',
                text: ''
            })
        );

        api.request('phone-confirm-code', params)
            .done((result = {}) => {
                if (result.status === 'ok') {
                    if (isStandAloneChallenge) {
                        dispatch(userValidateCommit());
                        return;
                    }

                    dispatch(commitChallenge());
                    metrics.send([CHALLENGES_PAGE, CHALLENGES_PAGE_PHONE_CALL_SUCCESS]);
                } else {
                    dispatch(handleError('internal'));
                    dispatch(domikIsLoading(false));
                }
            })
            .fail((error = {}) => {
                const errorCode = Array.isArray(error.errors) && error.errors[0];

                dispatch(domikIsLoading(false));

                if (errorCode === 'confirmations_limit.exceeded') {
                    dispatch(handleError('challenge.confirmations_limit.exceeded'));
                    return;
                }

                dispatch(handleError(errorCode));
                metrics.send([CHALLENGES_PAGE, `${CHALLENGES_PAGE_PHONE_CALL_ERROR} ${errorCode}`]);
            });
    };
}
