import api from '../../../api';
import {setChallengeError} from './';
import {domikIsLoading} from '../';
import handleError from './handleError';

import metrics from '../../../metrics';
import {
    CHALLENGES_PAGE,
    CHALLENGES_PAGE_PHONE_ENTERED,
    CHALLENGES_PAGE_EMAIL_ENTERED,
    CHALLENGES_PAGE_PUSH_ENTERED,
    CHALLENGES_PAGE_EMAIL_CODE_ENTERED,
    CHALLENGES_PAGE_PHONE_ERROR,
    CHALLENGES_PAGE_EMAIL_ERROR,
    CHALLENGES_PAGE_PUSH_ERROR,
    CHALLENGES_PAGE_EMAIL_CODE_ERROR
} from '../../metrics_constants';

const MAP_METRICS_PARAMS_SUCCESS = {
    phone: CHALLENGES_PAGE_PHONE_ENTERED,
    email: CHALLENGES_PAGE_EMAIL_ENTERED,
    push_2fa: CHALLENGES_PAGE_PUSH_ENTERED,
    email_code: CHALLENGES_PAGE_EMAIL_CODE_ENTERED
};

const MAP_METRICS_PARAMS_FAIL = {
    phone: CHALLENGES_PAGE_PHONE_ERROR,
    email: CHALLENGES_PAGE_EMAIL_ERROR,
    push_2fa: CHALLENGES_PAGE_PUSH_ERROR,
    email_code: CHALLENGES_PAGE_EMAIL_CODE_ERROR
};

export default function commitChallenge() {
    return (dispatch, getState) => {
        const {
            common: {track_id: trackId, csrf, retpath},
            challenge: {challengeType, fieldValue}
        } = getState();
        const params = {
            track_id: trackId,
            csrf_token: csrf,
            challenge: challengeType
        };

        if (!['phone_confirmation', 'email_code'].includes(challengeType)) {
            params.answer = fieldValue;

            if (!fieldValue.trim()) {
                dispatch(handleError('missingvalue'));
                dispatch(domikIsLoading(false));
                return;
            }
        }

        dispatch(domikIsLoading(true));

        api.request('auth/challenge/commit', params)
            .done(({status, isSocial} = {}) => {
                if (status === 'ok') {
                    let redirectUrl = `/auth${isSocial ? '/social' : ''}/finish/?track_id=${trackId}`;
                    const metricsParam = MAP_METRICS_PARAMS_SUCCESS[challengeType];

                    if (retpath) {
                        redirectUrl += `&retpath=${encodeURIComponent(retpath)}`;
                    }

                    metrics.send([CHALLENGES_PAGE, metricsParam]);
                    window.location.href = redirectUrl;
                    return;
                }

                dispatch(
                    setChallengeError({
                        code: 'internal',
                        text: i18n('_AUTH_.avatar.error-internal')
                    })
                );
                dispatch(domikIsLoading(false));
            })
            .fail((error) => {
                const errorCode = Array.isArray(error.error) && error.error[0];
                const metricsParam = MAP_METRICS_PARAMS_FAIL[challengeType];

                dispatch(handleError(errorCode));
                dispatch(domikIsLoading(false));
                metrics.send([CHALLENGES_PAGE, `${metricsParam} ${errorCode}`]);
            });
    };
}
