import api from '../../../api';
import commitChallenge from './commitChallenge';
import handleError from './handleError';
import {domikIsLoading} from '../';
import {setChallengeError} from './index';
import metrics from '../../../metrics';
import {
    CHALLENGES_PAGE,
    CHALLENGES_PAGE_EMAIL_CODE_ERROR,
    CHALLENGES_PAGE_EMAIL_CODE_CONFIRM_SUCCESS
} from '../../metrics_constants';

export default function confirmEmailCode() {
    return (dispatch, getState) => {
        const {
            challenge: {fieldValue},
            common: {track_id: trackId, csrf},
            auth: {processedAccount, defaultAccount}
        } = getState();
        const account = processedAccount ? processedAccount : defaultAccount;
        const code = fieldValue;
        const params = {
            code,
            trackId,
            csrf_token: csrf,
            uid: account ? account.uid : ''
        };

        dispatch(domikIsLoading(true));
        dispatch(
            setChallengeError({
                code: '',
                text: ''
            })
        );

        api.request('auth/challenge/confirm_email_code', params)
            .done((result = {}) => {
                if (result.status === 'ok') {
                    dispatch(commitChallenge());
                    metrics.send([CHALLENGES_PAGE, CHALLENGES_PAGE_EMAIL_CODE_CONFIRM_SUCCESS]);
                    return;
                }

                dispatch(handleError('internal'));
                dispatch(domikIsLoading(false));
            })
            .fail((error = {}) => {
                const errorCode = Array.isArray(error.error) && error.error[0];

                dispatch(domikIsLoading(false));

                if (errorCode === 'rate.limit_exceeded') {
                    dispatch(handleError('email_confirmations_limit.exceeded'));
                    return;
                }

                dispatch(handleError(errorCode));
                metrics.send([CHALLENGES_PAGE, `${CHALLENGES_PAGE_EMAIL_CODE_ERROR} ${errorCode}`]);
            });
    };
}
