import api from '../../../api';
import {setChallengeData} from '.';
import {changePagePopupType, changePagePopupVisibility, domikIsLoading} from '../';
import handleError from './handleError';
import {isAndroidAm} from '@blocks/selectors';

export default function confirmPhone() {
    return (dispatch, getState) => {
        const state = getState();
        const {
            challenge: {phoneId, isConfirmWithCall},
            common: {track_id: trackId, csrf},
            pagePopup: {isShowPagePopup}
        } = state;
        const params = {
            phone_id: phoneId,
            confirm_method: 'by_sms',
            track_id: trackId,
            csrf_token: csrf
        };

        if (isConfirmWithCall) {
            params.confirm_method = 'by_call';
        }

        if (!isAndroidAm(state)) {
            params.isCodeWithFormat = true;
        }

        dispatch(domikIsLoading(true));
        dispatch(
            setChallengeData({
                errorText: '',
                errorCode: '',
                fieldValue: ''
            })
        );

        api.request('phone-confirm-code-submit', params)
            .done((result = {}) => {
                if (result.status === 'ok' && result.calling_number_template) {
                    dispatch(
                        setChallengeData({
                            callFrom: result.calling_number_template
                        })
                    );
                }

                if (params.confirm_method === 'by_sms' && result.number) {
                    dispatch(
                        setChallengeData({
                            smsTo: result.number.masked_international
                        })
                    );
                }

                if (!isShowPagePopup) {
                    dispatch(changePagePopupType('challengeCall'));
                    dispatch(changePagePopupVisibility(true));
                }
            })
            .fail((error) => {
                const errorCode = Array.isArray(error.errors) && error.errors[0];

                dispatch(handleError(errorCode));
            })
            .always(() => {
                dispatch(domikIsLoading(false));
            });
    };
}
