import {setChallengeError} from './';
import {errors as errorTexts} from '../../pages/Challenge/errors';
import authErrors from '../../errors';

const isErrorToRedirect = (errorCode) => {
    return [
        'track_id.empty',
        'track_id.invalid',
        'track.not_found',
        'unknowntrack',
        'track.invalid_state',
        'action.impossible',
        'challenge.not_enabled',
        'account.not_found',
        'account.disabled',
        'account.disabled_on_deletion',
        'account.global_logout',
        'sessionid.overflow',
        'account.global_logout'
    ].includes(errorCode);
};

export default function handleError(errorCode) {
    return (dispatch, getState) => {
        const {
            common: {retpath, authUrl},
            challenge: {challengeType, isStandAloneChallenge}
        } = getState();

        if (errorCode === 'phone.confirmed') {
            location.href = `/profile${location.search}`;
            return;
        }

        if (isErrorToRedirect(errorCode)) {
            window.location.href = isStandAloneChallenge ? retpath : authUrl;
            return;
        }

        if (errorCode === 'account.auth_passed') {
            window.location.href = retpath;
            return;
        }

        if (challengeType || errorCode === 'challenge.limit_exceeded') {
            dispatch(
                setChallengeError({
                    code: errorCode,
                    text: getErrorText(errorCode, challengeType)
                })
            );
        }
    };
}

function getErrorText(errorCode, challengeType) {
    const challengeErrors = Object.assign({}, errorTexts, authErrors);
    const errorText = ['phone_confirmation', 'push_2fa', 'email_code'].includes(challengeType)
        ? challengeErrors[errorCode]
        : challengeErrors[`${challengeType}.${errorCode}`];

    return errorText || i18n('_AUTH_.avatar.error-internal');
}
