import api from '@blocks/api';
import {domikIsLoading} from '../';
import handleError from './handleError';

export default function sendCodeToEmail() {
    return (dispatch, getState) => {
        const {
            common: {track_id: trackId}
        } = getState();

        dispatch(domikIsLoading(true));

        api.request('auth/challenge/send_code_to_email', {track_id: trackId})
            .done(({status} = {}) => {
                if (status === 'ok') {
                    dispatch(domikIsLoading(false));
                    return;
                }

                dispatch(handleError('internal'));
                dispatch(domikIsLoading(false));
            })
            .fail((error) => {
                const errorCode = Array.isArray(error.error) && error.error[0];

                dispatch(handleError(errorCode));
                dispatch(domikIsLoading(false));
            });
    };
}
