import api from '@blocks/api';
import {setChallengeError} from './';
import {domikIsLoading} from '../';
import handleError from './handleError';

export default function sendPush() {
    return (dispatch, getState) => {
        const {
            common: {track_id: trackId}
        } = getState();

        dispatch(domikIsLoading(true));

        api.request('auth/challenge/send_push', {track_id: trackId})
            .done(({status} = {}) => {
                if (status === 'ok') {
                    dispatch(domikIsLoading(false));
                    return;
                }

                dispatch(
                    setChallengeError({
                        code: 'internal',
                        text: i18n('_AUTH_.avatar.error-internal')
                    })
                );
                dispatch(domikIsLoading(false));
            })
            .fail((error) => {
                const errorCode = Array.isArray(error.error) && error.error[0];

                dispatch(handleError(errorCode));
                dispatch(domikIsLoading(false));
            });
    };
}
