import {push} from 'connected-react-router';
import {amSetAnalyticsToRetpath} from '@blocks/authv2/actions/nativeMobileApi';
import api from '../../../api';
import {setChallengeData} from './';
import {domikIsLoading} from '../';
import handleError from './handleError';

export default function sendToChallenge() {
    return (dispatch, getState) => {
        const {
            common: {challengeUrl, track_id: trackId, csrf},
            am = {}
        } = getState();
        const params = {
            track_id: trackId,
            csrf_token: csrf
        };

        if (am.isAm) {
            dispatch(amSetAnalyticsToRetpath('external_action_webview', trackId));
        }

        api.request('auth/challenge/submit', params)
            .done((response) => {
                const {challenge = {}} = response;

                dispatch(setChallengeData(challenge));
                dispatch(push(`${challengeUrl}${trackId}`));
            })
            .fail((error) => {
                const errorCode = Array.isArray(error.error) && error.error[0];

                dispatch(handleError(errorCode));

                if (errorCode === 'challenge.limit_exceeded') {
                    dispatch(push(`${challengeUrl}${trackId}`));
                }
            })
            .always(() => {
                dispatch(domikIsLoading(false));
            });
    };
}
