import api from '../../../api';
import {domikIsLoading} from '../';
import confirmPhone from './confirmPhone';
import {setChallengeData, setChallengeError} from './index';
import handleError from './handleError';

export default function validatePhone() {
    return (dispatch, getState) => {
        const {
            challenge: {phoneId, isStandAloneChallenge, challengeType},
            common: {track_id: trackId, csrf}
        } = getState();

        const params = {
            phoneId,
            track_id: trackId,
            csrf_token: csrf
        };

        dispatch(domikIsLoading(true));
        dispatch(setChallengeError({code: '', text: ''}));

        if (isStandAloneChallenge) {
            const isConfirmWithCall = challengeType === 'dictation';

            dispatch(setChallengeData({isConfirmWithCall}));
            dispatch(confirmPhone());
            return;
        }

        api.request('auth/validate_phone_by_id', params)
            .done((result) => {
                const isValid = result.valid_for_call;

                dispatch(setChallengeData({isConfirmWithCall: !!isValid}));
                dispatch(confirmPhone());
            })
            .fail((error) => {
                const errorCode = Array.isArray(error.errors) && error.errors[0];

                dispatch(handleError(errorCode));
            })
            .always(() => {
                dispatch(domikIsLoading(false));
            });
    };
}
