import api from '../../api';
import {domikIsLoading} from './';
import showAccounts from './showAccounts';
import redirectToRetpath from './redirectToRetpath';

export default function changeActiveAccount(uid) {
    return function(dispatch, getState) {
        const {
            common: {profile_url: profileUrl, csrf, yu, retpath}
        } = getState();
        const params = {
            csrf_token: csrf,
            retpath: retpath || profileUrl,
            uid,
            yu
        };

        dispatch(domikIsLoading(true));

        api.request('auth/change_default', params)
            .done(() => {
                dispatch(showAccounts(true));
                dispatch(redirectToRetpath());
            })
            .fail(() => {
                dispatch(showAccounts());
                dispatch(domikIsLoading(false));
            });
    };
}
