import api from '../../api';
import {
    setAuthMailError,
    setAuthMailCancelled,
    domikIsLoading,
    changePagePopupType,
    changePagePopupVisibility
} from './';
import {getRedirectUrl} from '@blocks/selectors';
import {ACCOUNT_TYPES, getAccountTypeByAlias} from '@blocks/authv2/utils/accountTypes';
import {amSetAnalyticsToRetpath} from '@blocks/authv2/actions/nativeMobileApi';

export default function checkAuthLetterStatus() {
    return (dispatch, getState) => {
        const state = getState();
        const {
            common: {csrf, track_id: trackId},
            auth: {processedAccount},
            am = {}
        } = state;
        const {primaryAliasType} = processedAccount || {};
        const isMailAuth = getAccountTypeByAlias(primaryAliasType) === ACCOUNT_TYPES.LITE;

        let retpath = getRedirectUrl(state);

        if (am.isAm) {
            dispatch(amSetAnalyticsToRetpath('magic_link_auth'));
            retpath = getRedirectUrl(getState());
        }

        const params = {
            csrf_token: csrf,
            track_id: trackId,
            retpath
        };

        dispatch(domikIsLoading(true));
        dispatch(setAuthMailError(''));

        api.request('/auth/letter/status/', params)
            .done((response) => {
                if (response && response.status === 'ok' && response.magic_link_confirmed) {
                    let redirectUrl = `/auth/finish/?track_id=${response.track_id}`;

                    dispatch(setAuthMailError(''));

                    if (response.retpath || retpath) {
                        redirectUrl += `&retpath=${encodeURIComponent(response.retpath || retpath)}`;
                    }

                    window.location.href = redirectUrl;
                    return;
                }
                dispatch(changePagePopupVisibility(true));
                dispatch(changePagePopupType(isMailAuth ? 'authLetter' : 'authMessenger'));
                dispatch(setAuthMailCancelled(false));
            })
            .fail((response) => {
                const errorCode = Array.isArray(response.errors) ? response.errors[0] : 'global';

                dispatch(setAuthMailError(errorCode));
            })
            .always(() => {
                dispatch(domikIsLoading(false));
            });
    };
}
