import api from '@blocks/api';
import reloadCaptcha from '@components/Captcha/actions/reloadCaptcha';
import {setCaptchaError, changeCaptchaState, domikIsLoading} from './';
import {getFormValues, getTrackId} from '@blocks/selectors';
import {TRACK_TYPES} from '@blocks/actions/tracks';
import {FIELDS_NAMES} from '@components/Field';
import {updateErrors} from '@blocks/actions/form';
import {getError} from '@blocks/utils';

export default function checkCaptcha(params = {}) {
    const {action, actionArguments = [], callback} = params;

    return function(dispatch, getState) {
        const state = getState();
        const {
            auth: {form: {captcha_answer: captchaAnswer} = {}} = {},
            common: {csrf},
            captcha: {trackId: captchaTrackId, key}
        } = state;
        const formValues = getFormValues(state);
        const answer = formValues[FIELDS_NAMES.CAPTCHA] || captchaAnswer;
        const params = {
            track_id:
                captchaTrackId || getTrackId(state, TRACK_TYPES.REGISTER) || getTrackId(state, TRACK_TYPES.COMMON),
            csrf_token: csrf,
            answer
        };

        if (key) {
            params.key = key;
        }

        dispatch(domikIsLoading(true));

        if (!answer || !answer.trim()) {
            dispatch(setCaptchaError('captcha.empty'));
            dispatch(
                updateErrors({
                    field: FIELDS_NAMES.CAPTCHA,
                    error: getError(FIELDS_NAMES.CAPTCHA, 'captcha.empty')
                })
            );
            dispatch(domikIsLoading(false));
            return;
        }

        api.request('checkHuman', params)
            .done((response) => {
                dispatch(domikIsLoading(false));

                if (response.status === 'ok') {
                    dispatch(setCaptchaError(''));
                    dispatch(
                        updateErrors({
                            field: FIELDS_NAMES.CAPTCHA,
                            error: {}
                        })
                    );
                    dispatch(changeCaptchaState(false));

                    if (action) {
                        dispatch(action(...actionArguments));
                    }

                    if (typeof callback === 'function') {
                        callback();
                    }

                    return;
                }

                dispatch(reloadCaptcha());
                dispatch(setCaptchaError(response.errors));
                dispatch(
                    updateErrors({
                        field: FIELDS_NAMES.CAPTCHA,
                        error: getError(FIELDS_NAMES.CAPTCHA, response.errors)
                    })
                );
            })
            .fail((error) => {
                dispatch(reloadCaptcha());
                dispatch(setCaptchaError(error.errors));
                dispatch(
                    updateErrors({
                        field: FIELDS_NAMES.CAPTCHA,
                        error: getError(FIELDS_NAMES.CAPTCHA, error.errors)
                    })
                );
                dispatch(domikIsLoading(false));
            });
    };
}
