import api from '../../api';
import {setAuthMailConfirmed, setAuthMailError} from './';
import {
    AUTH_LETTER_FAIL_AUTH,
    AUTH_LETTER_SUCCESS_AUTH,
    AUTH_MESSENGER_SUCCESS_AUTH,
    AUTH_MESSENGER_FAIL_AUTH
} from '../metrics_constants';
import metrics from '../../metrics';
import {ACCOUNT_TYPES, getAccountTypeByAlias} from '@blocks/authv2/utils/accountTypes';

export default function confirmAuthFromLetter() {
    return (dispatch, getState) => {
        const {
            common: {csrf},
            settings: {language},
            mailAuth: {isRedirect, isRegister, secret, mailTrack},
            auth: {processedAccount}
        } = getState();
        const {primaryAliasType} = processedAccount || {};
        const isMailAuth = getAccountTypeByAlias(primaryAliasType) === ACCOUNT_TYPES.LITE;

        const params = {
            csrf_token: csrf,
            secret,
            track_id: mailTrack,
            isRegister,
            language
        };

        if (isRedirect) {
            params.redirect = 'true';
        }

        api.request('auth/confirm_magic_letter', params)
            .done((response = {}) => {
                if (response.status === 'ok') {
                    if (typeof response.retpath !== 'undefined') {
                        const a = document.createElement('a');

                        a.href = window.location.href;
                        a.pathname = '/redirect';
                        a.search = `?url=${encodeURIComponent(response.retpath)}`;

                        if (response.retpath.match(/show_back_to_app_screen/) !== null) {
                            dispatch(setAuthMailConfirmed(a.href));
                        } else {
                            window.location.href = a.href;
                        }
                        return;
                    }

                    dispatch(setAuthMailConfirmed());
                    metrics.send([isMailAuth ? AUTH_LETTER_SUCCESS_AUTH : AUTH_MESSENGER_SUCCESS_AUTH]);
                }
            })
            .fail((result = {}) => {
                const errorCode = result.errors && Array.isArray(result.errors) ? result.errors[0] : 'global';

                dispatch(setAuthMailError(errorCode));
                metrics.send([isMailAuth ? AUTH_LETTER_FAIL_AUTH : AUTH_MESSENGER_FAIL_AUTH, errorCode]);
            });
    };
}
