import api from '@blocks/api';
import {TRACK_TYPES} from '@blocks/actions/tracks.js';
import {getTrackId, getFormValues} from '@blocks/selectors';
import {updateChangePasswordStep} from '@blocks/authv2/actions/forcePasswordChange';
import processErrors from '@blocks/authv2/actions/forcePasswordChange/processErrors';

export default function checkAnswer() {
    return (dispatch, getState) => {
        const state = getState();
        const formValues = getFormValues(state);
        const {hint_answer, hint_question_id, hint_question} = formValues;
        const params = {
            track_id: getTrackId(state, TRACK_TYPES.COMMON),
            history_answer: hint_answer,
            history_question: `${hint_question_id}:${hint_question}`
        };

        if (!hint_answer.trim()) {
            dispatch(processErrors('answer.empty', 'hint_answer'));
            return;
        }

        api.request('history-answer', params)
            .done((response = {}) => {
                if (response.status === 'ok') {
                    dispatch(updateChangePasswordStep('bind-phone'));
                    return;
                }

                dispatch(processErrors('global'));
            })
            .fail((error = {}) => {
                dispatch(processErrors(error.validation_errors, 'hint_answer'));
            });
    };
}
