import api from '@blocks/api';
import {TRACK_TYPES} from '@blocks/actions/tracks.js';
import {getFormValues, getTrackId} from '@blocks/selectors';
import {domikIsLoading} from '@blocks/authv2/actions';
import {updateChangePasswordStep} from '@blocks/authv2/actions/forcePasswordChange';
import processErrors from '@blocks/authv2/actions/forcePasswordChange/processErrors';

export default function checkPhoneCode() {
    return (dispatch, getState) => {
        const state = getState();
        const {changePassword = {}} = state;
        const {number, step} = changePassword;
        const isConfirmBinded = Boolean(number) && step !== 'bind-phone';
        const code = getFormValues(state)['phoneCode'];

        if (!code.trim()) {
            dispatch(processErrors('code.missingvalue', 'phoneCode'));
            return;
        }

        dispatch(domikIsLoading(true));
        api.checkPhoneConfirmationCode({
            trackId: getTrackId(state, TRACK_TYPES.COMMON),
            code,
            mode: isConfirmBinded ? 'tracked' : ''
        })
            .then((response = {}) => {
                dispatch(domikIsLoading(false));

                if (response.status === 'ok') {
                    dispatch(updateChangePasswordStep('password'));
                    return;
                }

                dispatch(processErrors('global'));
            })
            .catch((error = {}) => {
                dispatch(domikIsLoading(false));
                dispatch(processErrors(error.errors, 'phoneCode'));
            });
    };
}
