import api from '@blocks/api';
import {getError} from '@blocks/utils';
import {updateErrors} from '@blocks/actions/form';
import {TRACK_TYPES} from '@blocks/actions/tracks.js';
import {getFormValues, getFormErrors, getTrackId} from '@blocks/selectors';
import {domikIsLoading} from '@blocks/authv2/actions';
import processErrors from '@blocks/authv2/actions/forcePasswordChange/processErrors';
import {
    updateChangePasswordStep,
    setPhoneConflictWarning,
    setSms2faUpdated
} from '@blocks/authv2/actions/forcePasswordChange';

export default function commitPassword() {
    return (dispatch, getState) => {
        const state = getState();
        const form = getFormValues(state);
        const passwordErrors = (getFormErrors(state) || {}).password;
        const {password, password_confirm} = form;
        const trackId = getTrackId(state, TRACK_TYPES.COMMON);
        const data = {
            track_id: trackId,
            password
        };

        if (passwordErrors && passwordErrors.code) {
            return;
        }

        if (!password.trim()) {
            dispatch(processErrors('password.empty', 'password'));
            return;
        }

        if (password !== password_confirm) {
            dispatch(updateErrors({field: 'password_confirm', error: getError('password_confirm', 'notequal')}));
            return;
        }

        dispatch(domikIsLoading(true));

        api.request('change-pwd-commit', data)
            .then((response = {}) => {
                dispatch(domikIsLoading(false));

                if (response.status === 'ok') {
                    const {changePassword = {}} = state;
                    const nextStep =
                        response.hasSms2faUpdated && !changePassword.hasSms2faEnabled ? 'finishExp' : 'finish';

                    if (response.isPhoneConflictsExist) {
                        dispatch(setPhoneConflictWarning(true));
                    }

                    if (response.hasSms2faUpdated && !changePassword.hasSms2faEnabled) {
                        dispatch(setSms2faUpdated());
                    }

                    dispatch(updateChangePasswordStep(nextStep));

                    return api.updateCsrfToken().then(() => {
                        api.writeStatbox({
                            track_id: trackId,
                            mode: 'change_password_force',
                            action: 'updated'
                        });
                    });
                }

                dispatch(processErrors());
            })
            .fail((error = {}) => {
                dispatch(domikIsLoading(false));
                dispatch(processErrors(error.error, 'password'));
            });
    };
}
