import api from '@blocks/api';
import {TRACK_TYPES} from '@blocks/actions/tracks.js';
import {getLanguage, getTrackId, getFormValues, isAndroidAm} from '@blocks/selectors';
import {domikIsLoading} from '@blocks/authv2/actions';
import {
    setPhoneConfirmationCallingNumberTemplate,
    setPhoneConfirmationDenyResendUntilTime,
    setPhoneConfirmationInternationalPhoneNumber,
    updatePhoneNumber
} from '@blocks/actions/phoneConfirm';
import {updatePhoneStatus} from './';
import processErrors from '@blocks/authv2/actions/forcePasswordChange/processErrors';
import {updateErrors} from '@blocks/actions/form';

export default function confirmPhone() {
    return (dispatch, getState) => {
        const state = getState();
        const {changePassword = {}} = state;
        const {step, number} = changePassword;
        const formValues = getFormValues(state);
        const isConfirmBinded = Boolean(number) && step !== 'bind-phone';

        dispatch(domikIsLoading(true));

        api.requestPhoneConfirmationCode({
            trackId: getTrackId(state, TRACK_TYPES.COMMON),
            language: getLanguage(state),
            phone: formValues.phone,
            mode: isConfirmBinded ? 'tracked' : '',
            isCodeWithFormat: !isAndroidAm(state)
        })
            .then((response = {}) => {
                const {denyResendUntil, phone, callingNumberTemplate, internationalPhoneNumber} = response;

                dispatch(setPhoneConfirmationDenyResendUntilTime(denyResendUntil));
                dispatch(updatePhoneNumber(phone));
                dispatch(setPhoneConfirmationInternationalPhoneNumber(internationalPhoneNumber));
                dispatch(setPhoneConfirmationCallingNumberTemplate(callingNumberTemplate));
                dispatch(domikIsLoading(false));
                dispatch(updatePhoneStatus('code-sent'));
                dispatch(updateErrors({field: 'phoneCode', error: {}}));
            })
            .catch((error = {}) => {
                const {errors = []} = error;

                dispatch(domikIsLoading(false));
                dispatch(processErrors(errors, 'phone'));
            });
    };
}
