import {updateErrors} from '@blocks/actions/form';
import switchToModeAddingAccount from '@blocks/authv2/actions/switchToModeAddingAccount';

const errorTexts = {
    hint_answer: {
        'answer.empty': i18n('_AUTH_.hint_answer_errors_missingvalue'),
        'compare.not_matched': i18n('_AUTH_.question.answer_not_matched'),
        'rate.limit_exceeded': i18n('_AUTH_.question.attempts_limit_exceeded')
    },
    phone: {
        'number.invalid': i18n('_AUTH_.phone_number_errors_badphonenumber'),
        'sms_limit.exceeded': i18n('_AUTH_.phones.errors.limit-exceeded'),
        badphonenumber: i18n('_AUTH_.phone_number_errors_badphonenumber'),
        'phone.compromised': i18n('_AUTH_.phone-confirm_errors_compromised_v2')
    },
    phoneCode: {
        'code.invalid': i18n('_AUTH_.phone-confirm_errors_codeinvalid'),
        'code.missingvalue': i18n('_AUTH_.phone-confirm_errors_missingvalue'),
        'confirmations_limit.exceeded': i18n('_AUTH_.phones.errors.confirmation-limit-exceeded')
    },
    password: {
        'password.empty': i18n('_AUTH_.password_errors_missingvalue'),
        'password.likelogin': i18n('_AUTH_.password_errors_likelogin'),
        'password.likephonenumber': i18n('_AUTH_.password_errors_likephonenumber'),
        'password.equals_previous': i18n('_AUTH_.password_errors_equals_previous'),
        'password.found_in_history': i18n('_AUTH_.password_errors_foundinhistory'),
        'phone.compromised': i18n('_AUTH_.phone-confirm_errors_compromised_v2'),
        'account.compromised': i18n('_AUTH_.ErrorsTexts.account_compromised'),
        'sessionid.overflow': i18n('_AUTH_.Errors.sessionidoverflow')
    }
};

export default function processErrors(error = 'global', field) {
    const errorCode = Array.isArray(error) ? error[0] : error;

    return (dispatch) => {
        const errorData = {
            code: errorCode,
            text: field ? errorTexts[field][errorCode] : i18n('_AUTH_.errors.globalinternal')
        };

        if (errorCode === 'track.invalid_state' || errorCode === 'action.not_required') {
            dispatch(switchToModeAddingAccount());
            return;
        }

        dispatch(updateErrors({field, error: errorData}));
    };
}
