import api from '@blocks/api';
import {TRACK_TYPES} from '@blocks/actions/tracks.js';
import {domikIsLoading, setPasswordError} from '../';
import switchToChangePassword from '../switchToChangePassword';
import {setChangePasswordData, updateChangePasswordStep, updatePhoneStatus, setPhoneNumberUpdated} from './';
import {updateQuestionValues, clearForm} from '@blocks/actions/form';
import {getTrackId} from '@blocks/selectors';

export default function sendToForcePasswordChange() {
    return (dispatch, getState) => {
        const state = getState();
        const trackId = getTrackId(state, TRACK_TYPES.COMMON);
        const {changePassword = {}} = state;
        const {status: phoneStatus} = changePassword;

        dispatch(domikIsLoading(true));

        api.request('auth/password/state', {track_id: trackId})
            .done((response = {}) => {
                const {status, state} = response;

                if (status === 'ok') {
                    dispatch(clearForm());
                    dispatch(updateChangePasswordStep(''));
                    dispatch(setPhoneNumberUpdated(false));
                    dispatch(switchToChangePassword());
                    dispatch(setChangePasswordData(state));

                    if (phoneStatus !== 'phone-confirmed') {
                        dispatch(updatePhoneStatus(''));
                    }

                    if (state.question) {
                        dispatch(
                            updateQuestionValues({
                                hint_question_id: state.question.id,
                                hint_question: state.question.text
                            })
                        );
                    }

                    api.writeStatbox({
                        track_id: trackId,
                        mode: 'change_password_force',
                        action: 'opened'
                    });
                }
            })
            .fail((error = {}) => {
                dispatch(setPasswordError(error));
            })
            .always(() => {
                dispatch(domikIsLoading(false));
            });
    };
}
