import api from '../../api';
import {domikIsLoading, changeMobileMenuVisibility} from './';
import showAccounts from './showAccounts';

export default function forgetAccount(uid) {
    return function(dispatch, getState) {
        const {
            settings: {ua},
            common: {csrf}
        } = getState();
        const isTouch = ua && ua.isTouch;
        const params = {
            _uid: uid,
            csrf_token: csrf
        };

        dispatch(domikIsLoading(true));

        api.request('accounts/forget', params)
            .done(() => {
                dispatch(showAccounts());

                if (isTouch) {
                    dispatch(changeMobileMenuVisibility(false));
                }
            })
            .fail(() => {
                dispatch(showAccounts());
            })
            .always(() => dispatch(domikIsLoading(false)));
    };
}
