export * from './person';

export const UPDATE_LOGIN_VALUE = 'UPDATE_LOGIN_VALUE';
export const UPDATE_PASSWORD_VALUE = 'UPDATE_PASSWORD_VALUE';

export const UPDATE_2FA_PICTURES = 'UPDATE_2FA_PICTURES';

export const UPDATE_TOKENS_SUCCESS = 'UPDATE_TOKENS_SUCCESS';
export const UPDATE_MAGIC_TOKENS_SUCCESS = 'UPDATE_MAGIC_TOKENS_SUCCESS';

export const CHANGE_PROCESSED_ACCOUNT = 'CHANGE_PROCESSED_ACCOUNT';

export const CHANGE_MOBILE_MENU_VISIBILITY = 'CHANGE_MOBILE_MENU_VISIBILITY';
export const CHANGE_MOBILE_MENU_TYPE = 'CHANGE_MOBILE_MENU_TYPE';
export const SET_PROCESSED_ACCOUNT_UID = 'SET_PROCESSED_ACCOUNT_UID';

export const CHANGE_PAGE_POPUP_VISIBILITY = 'CHANGE_PAGE_POPUP_VISIBILITY';
export const CHANGE_PAGE_POPUP_TYPE = 'CHANGE_PAGE_POPUP_TYPE';

export const CHANGE_ACTIVE_ACCOUNT = 'CHANGE_ACTIVE_ACCOUNT';
export const LOGIN_SUGGESTED_ACCOUNT = 'LOGIN_SUGGESTED_ACCOUNT';
export const REDIRECT_TO_RETPATH = 'REDIRECT_TO_RETPATH';
export const REDIRECT_TO_BACKPATH = 'REDIRECT_TO_BACKPATH';

export const INPUT_LOGIN_SUCCESS = 'INPUT_LOGIN_SUCCESS';

export const SHOW_ACCOUNTS_SUCCESS = 'SHOW_ACCOUNTS_SUCCESS';
export const SHOW_ACCOUNTS_FAIL = 'SHOW_ACCOUNTS_FAIL';

export const DOMIK_IS_LOADING = 'DOMIK_IS_LOADING';

export const SWITCH_TO_MODE_EDIT = 'SWITCH_TO_MODE_EDIT';
export const SWITCH_TO_MODE_RESTORE_LOGIN = 'SWITCH_TO_MODE_RESTORE_LOGIN';
export const SWITCH_TO_MODE_RESTORE_LOGIN_PROCESS = 'SWITCH_TO_MODE_RESTORE_LOGIN_PROCESS';
export const SWITCH_TO_MODE_RESTORE_LOGIN_RESULT = 'SWITCH_TO_MODE_RESTORE_LOGIN_RESULT';
export const SWITCH_TO_MODE_ADDING_ACCOUNT = 'SWITCH_TO_MODE_ADDING_ACCOUNT';
export const SWITCH_TO_MODE_WELCOME = 'SWITCH_TO_MODE_WELCOME';
export const SWITCH_TO_MODE_MAGIC = 'SWITCH_TO_MODE_MAGIC';
export const SETUP_BACK_PANE = 'SETUP_BACK_PANE';

export const SET_LOGIN_ERROR = 'SET_LOGIN_ERROR';
export const SET_LOGIN_IS_ABLE_TO_RESTORE = 'SET_LOGIN_IS_ABLE_TO_RESTORE';
export const SET_PASSWORD_ERROR = 'SET_PASSWORD_ERROR';
export const SET_CAPTCHA_ERROR = 'SET_CAPTCHA_ERROR';
export const SET_MAGIC_ERROR = 'SET_MAGIC_ERROR';
export const CAN_REGISTER = 'CAN_REGISTER';
export const CHANGE_CAPTCHA_STATE = 'CHANGE_CAPTCHA_STATE';
export const UPDATE_CAPTCHA_VALUE = 'UPDATE_CAPTCHA_VALUE';

export const FORCE_OTP_METHOD = 'FORCE_OTP_METHOD';

export const SETUP_MODE = 'SETUP_MODE';

export const TOGGLE_MAIL_SENT_TOOLTIP = 'TOGGLE_MAIL_SENT_TOOLTIP';
export const AUTH_MAIL_SENT = 'AUTH_MAIL_SENT';
export const AUTH_MAIL_CONFIRMED = 'AUTH_MAIL_CONFIRMED';
export const AUTH_MAIL_CANCELLED = 'AUTH_MAIL_CANCELLED';
export const SET_AUTH_MAIL_ERROR = 'SET_AUTH_MAIL_ERROR';
export const SET_AUTH_MAIL_UPDATED = 'SET_AUTH_MAIL_UPDATED';
export const SET_AUTH_MAIL_DISABLED = 'SET_AUTH_MAIL_DISABLED';
export const SET_AUTH_MAIL_ENABLED = 'SET_AUTH_MAIL_ENABLED';

export const INIT_ADDITIONAL_DATA_REQUEST = 'INIT_ADDITIONAL_DATA_REQUEST';

export const TOGGLE_CONTEXT_MENU_VISIBILITY = '[AUTH] TOGGLE_CONTEXT_MENU_VISIBILITY';
export const SET_CONTEXT_MENU_ANCHOR = '[AUTH] SET_CONTEXT_MENU_ANCHOR';
export const SET_CONTEXT_MENU_TYPE = '[AUTH] SET_CONTEXT_MENU_TYPE';
export const CLEAR_CONTEXT_MENU_STATE = '[AUTH] CLEAR_CONTEXT_MENU_STATE';

export const SET_MAGIC_SUCCESS = 'SET_MAGIC_SUCCESS';

export const SET_TYPE_IMAGE_2FA = 'SET_TYPE_IMAGE_2FA';

export const TOGGLE_LOGIN_FIELD_TYPE = 'TOGGLE_LOGIN_FIELD_TYPE';

export function domikIsLoading(loading) {
    return {
        type: DOMIK_IS_LOADING,
        loading
    };
}

export function updateLoginValue(value) {
    return {
        type: UPDATE_LOGIN_VALUE,
        value
    };
}

export function changeProcessedAccount(account) {
    return {
        type: CHANGE_PROCESSED_ACCOUNT,
        account
    };
}

export function updatePasswordValue(value) {
    return {
        type: UPDATE_PASSWORD_VALUE,
        value
    };
}

export function updateCaptchaValue(value) {
    return {
        type: UPDATE_CAPTCHA_VALUE,
        value
    };
}

export function updateTokensSuccess(trackId, csrf) {
    return {
        type: UPDATE_TOKENS_SUCCESS,
        track_id: trackId,
        csrf_token: csrf
    };
}

export function updateMagicTokensSuccess(trackId, csrf) {
    return {
        type: UPDATE_MAGIC_TOKENS_SUCCESS,
        track: trackId,
        csrf
    };
}

export function canRegister({
    isCanRegister,
    registrationLogin,
    registrationType,
    registrationPhoneNumber,
    registrationCountry
}) {
    return {
        type: CAN_REGISTER,
        isCanRegister,
        registrationLogin,
        registrationType,
        registrationPhoneNumber,
        registrationCountry
    };
}

export function setupBackPane(pane) {
    return {
        type: SETUP_BACK_PANE,
        pane
    };
}

export function setLoginError(error) {
    return {
        type: SET_LOGIN_ERROR,
        error
    };
}

export function setLoginAbleToRestore(isAbleToRestore) {
    return {
        type: SET_LOGIN_IS_ABLE_TO_RESTORE,
        isAbleToRestore
    };
}

export function setPasswordError(error) {
    return {
        type: SET_PASSWORD_ERROR,
        error
    };
}

export function setCaptchaError(error) {
    return {
        type: SET_CAPTCHA_ERROR,
        error
    };
}

export function setMagicError(error) {
    return {
        type: SET_MAGIC_ERROR,
        error
    };
}

export function changeCaptchaState(isCaptchaRequired) {
    return {
        type: CHANGE_CAPTCHA_STATE,
        isCaptchaRequired
    };
}

export function setupMode(mode) {
    return {
        type: SETUP_MODE,
        mode
    };
}

export function forceOTPMethod(isForceOTP) {
    return {
        type: FORCE_OTP_METHOD,
        isForceOTP
    };
}

export function changeMobileMenuVisibility(visible) {
    return {
        type: CHANGE_MOBILE_MENU_VISIBILITY,
        visible
    };
}

export function changeMobileMenuType(mobileMenuType) {
    return {
        type: CHANGE_MOBILE_MENU_TYPE,
        mobileMenuType
    };
}

export function changePagePopupVisibility(visible) {
    return {
        type: CHANGE_PAGE_POPUP_VISIBILITY,
        visible
    };
}

export function changePagePopupType(pagePopupType) {
    return {
        type: CHANGE_PAGE_POPUP_TYPE,
        pagePopupType
    };
}

export function setProccessedAccountUid(processedAccountUid) {
    return {
        type: SET_PROCESSED_ACCOUNT_UID,
        processedAccountUid
    };
}

export function setAuthMailSent(code) {
    return {
        type: AUTH_MAIL_SENT,
        code
    };
}

export function setAuthMailConfirmed(retpath) {
    return {
        type: AUTH_MAIL_CONFIRMED,
        retpath
    };
}

export function setAuthMailCancelled(status) {
    return {
        type: AUTH_MAIL_CANCELLED,
        status
    };
}

export function setAuthMailError(error) {
    return {
        type: SET_AUTH_MAIL_ERROR,
        error
    };
}

export function updateAuthMailStatus(isUpdated) {
    return {
        type: SET_AUTH_MAIL_UPDATED,
        isUpdated
    };
}

export function update2faPictures(auth2faPictures) {
    return {
        type: UPDATE_2FA_PICTURES,
        auth2faPictures
    };
}

export function setMagicLinkDisabled() {
    return {
        type: SET_AUTH_MAIL_DISABLED
    };
}

export function enableAuthMailStatus() {
    return {
        type: SET_AUTH_MAIL_ENABLED
    };
}

export function loginSuggestedAccountSuccess(account) {
    return {
        type: LOGIN_SUGGESTED_ACCOUNT,
        account
    };
}

export function inputLoginSuccess(inputLogin) {
    return {
        type: INPUT_LOGIN_SUCCESS,
        inputLogin
    };
}

export function showAccountsSuccess(accounts) {
    return {
        type: SHOW_ACCOUNTS_SUCCESS,
        accounts
    };
}

export function showAccountsFail(errors) {
    return {
        type: SHOW_ACCOUNTS_FAIL,
        errors
    };
}

export function switchToModeAddingAccountSuccess() {
    return {
        type: SWITCH_TO_MODE_ADDING_ACCOUNT
    };
}

export function switchToModeEditSuccess() {
    return {
        type: SWITCH_TO_MODE_EDIT
    };
}

export function switchToModeMagicSuccess(isFromLoginSuggest) {
    return {
        type: SWITCH_TO_MODE_MAGIC,
        isFromLoginSuggest
    };
}

export function switchToModeWelcomeSuccess() {
    return {
        type: SWITCH_TO_MODE_WELCOME
    };
}

export function switchToModeRestoreLoginSuccess() {
    return {
        type: SWITCH_TO_MODE_RESTORE_LOGIN
    };
}

export function switchToModeRestoreLoginProcessSuccess() {
    return {
        type: SWITCH_TO_MODE_RESTORE_LOGIN_PROCESS
    };
}

export function switchToModeRestoreLoginResultSuccess() {
    return {
        type: SWITCH_TO_MODE_RESTORE_LOGIN_RESULT
    };
}

export function redirectToRetpathSuccess() {
    return {
        type: REDIRECT_TO_RETPATH
    };
}

export function redirectToBackpathSuccess() {
    return {
        type: REDIRECT_TO_BACKPATH
    };
}

export function initAdditionalDataRequest(payload) {
    return {
        type: INIT_ADDITIONAL_DATA_REQUEST,
        payload
    };
}

export function toggleLoginFieldType(payload) {
    return {
        type: TOGGLE_LOGIN_FIELD_TYPE,
        loginFieldType: payload
    };
}

export function redirect(url) {
    const form = document.createElement('form');
    const element1 = document.createElement('input');

    form.method = 'GET';
    form.action = '/redirect';

    element1.value = url;
    element1.name = 'url';
    form.appendChild(element1);

    document.body.appendChild(form);

    form.submit();
    form.parentNode.removeChild(form);
}

export const toggleContextMenuVisibility = (visibility) => ({
    type: TOGGLE_CONTEXT_MENU_VISIBILITY,
    payload: visibility
});

export const setContextMenuAnchor = (anchor) => ({
    type: SET_CONTEXT_MENU_ANCHOR,
    payload: anchor
});

export const setContextMenuType = (type) => ({
    type: SET_CONTEXT_MENU_TYPE,
    payload: type
});

export const clearContextMenuState = () => ({
    type: CLEAR_CONTEXT_MENU_STATE
});

export const setMagicSuccess = (isMagicSuccess) => ({
    type: SET_MAGIC_SUCCESS,
    isMagicSuccess
});

export const setTypeImage2FA = (typeImage2FA) => ({
    type: SET_TYPE_IMAGE_2FA,
    typeImage2FA
});
