import api from '../../api';
import {setAuthMailCancelled, setAuthMailError, updateAuthMailStatus} from './';
import metrics from '../../metrics';
import {AUTH_LETTER_INVALIDATE, AUTH_LETTER_FAIL_AUTH, AUTH_MESSENGER_INVALIDATE} from '../metrics_constants';
import multiStepAuthStart from './multiStepAuthStart';
import {ACCOUNT_TYPES, getAccountTypeByAlias} from '@blocks/authv2/utils/accountTypes';

export default function invalidateAuthFromLetter() {
    return (dispatch, getState) => {
        const {
            common: {csrf, track_id: trackId},
            mailAuth: {mailTrack},
            auth: {processedAccount}
        } = getState();
        const {primaryAliasType} = processedAccount || {};
        const isMailAuth = getAccountTypeByAlias(primaryAliasType) === ACCOUNT_TYPES.LITE;

        const params = {
            csrf_token: csrf,
            track_id: mailTrack ? mailTrack : trackId
        };

        api.request('auth/invalidate_magic_letter', params)
            .done((response) => {
                if (response.status === 'ok') {
                    dispatch(setAuthMailCancelled(true));
                    metrics.send([isMailAuth ? AUTH_LETTER_INVALIDATE : AUTH_MESSENGER_INVALIDATE]);

                    if (!mailTrack) {
                        const invalidationStatus = isMailAuth ? 'magic_link.invalidated' : 'messenger_link.invalidated';

                        dispatch(setAuthMailError(invalidationStatus));
                        dispatch(multiStepAuthStart({login: processedAccount.login}));
                        dispatch(updateAuthMailStatus(true));
                    }
                }
            })
            .fail((result = {}) => {
                const errorCode = (Array.isArray(result.errors) && result.errors[0]) || 'global';

                dispatch(setAuthMailError(errorCode));
                metrics.send([AUTH_LETTER_FAIL_AUTH]);
            });
    };
}
