import api from '../../api';
import {
    loginSuggestedAccountSuccess,
    inputLoginSuccess,
    changeProcessedAccount,
    updateLoginValue,
    domikIsLoading
} from './';
import multiStepAuthStart from './multiStepAuthStart';
import switchToModeWelcome from './switchToModeWelcome';

export default function loginSuggestedAccount(account) {
    return function(dispatch, getState) {
        const {
            common: {csrf}
        } = getState();
        const {
            uid,
            status,
            login,
            preferred_auth_method: authMethod,
            allowed_auth_methods: allowedAuthMethods
        } = account;

        if (status === 'INVALID') {
            dispatch(domikIsLoading(false));
            dispatch(loginSuggestedAccountSuccess(account));
            dispatch(multiStepAuthStart({login}));

            return;
        }

        const params = {
            _uid: uid,
            csrf_token: csrf
        };

        dispatch(domikIsLoading(true));

        api.request('accounts/input-login', params)
            .done((res) => {
                const inputLogin = {};

                if (!res || !res.input_login) {
                    return;
                }

                inputLogin[uid] = res && res.input_login;

                dispatch(inputLoginSuccess(inputLogin));
            })
            .always(() => {
                dispatch(domikIsLoading(false));
                dispatch(loginSuggestedAccountSuccess(account));

                const isSocialAuth = (authMethod || '').indexOf('social_') > -1;
                const isMultiStepAuth = (allowedAuthMethods || []).some((method) =>
                    ['password', 'magic_link', 'magic', 'magic_x_token', 'rfc_totp', 'otp', 'sms_code'].includes(method)
                );

                if (isSocialAuth && !isMultiStepAuth) {
                    dispatch(changeProcessedAccount(account));
                    dispatch(updateLoginValue(login));
                    dispatch(switchToModeWelcome());
                    return;
                }

                dispatch(multiStepAuthStart({login}));
            });
    };
}
