import api from '../../api';
import {domikIsLoading, changeMobileMenuVisibility} from './';
import showAccounts from './showAccounts';

export default function logoutAccount(uid) {
    return function(dispatch, getState) {
        const {
            settings: {ua},
            common: {profile_url: profileUrl, csrf, yu, retpath}
        } = getState();

        const isTouch = ua && ua.isTouch;

        const params = {
            csrf_token: csrf,
            retpath: retpath || profileUrl,
            uid,
            yu
        };

        dispatch(domikIsLoading(true));

        api.request('auth/logout', params)
            .done(() => {
                dispatch(showAccounts());

                if (isTouch) {
                    dispatch(changeMobileMenuVisibility(false));
                }
            })
            .fail(() => {
                dispatch(showAccounts());
            })
            .always(() => dispatch(domikIsLoading(false)));
    };
}
