import {magicService} from '@blocks/AuthSilent/magicService';
import metrics from '@blocks/metrics';
import {SUCCESS_AUTH_GOAL} from '@blocks/authv2/metrics_constants';

export function magicDoneCallback(results) {
    if (results.state === 'auth_challenge') {
        magicService.stop();
        window.location.href = results.redirectUrl;
        return;
    }
    if (results.status === 'ok' && results.state === 'otp_auth_finished') {
        magicService.stop();
        metrics.goal(SUCCESS_AUTH_GOAL);

        window.location.href = `/auth/finish/?track_id=${magicService.trackId}`;
    }
}
