import {magicService} from '@blocks/AuthSilent/magicService';
import {setMagicError, changeCaptchaState} from '@blocks/authv2/actions';
import reAuthPasswordSubmit from '@blocks/authv2/actions/reAuthPasswordSubmit';
import {setCaptchaTrack} from '@components/Captcha/actions';

export function magicFailCallback(dispatch) {
    return (results) => {
        let error;

        if (results.errors || results.error) {
            error = results.errors && results.errors.length ? results.errors[0] : results.error;

            if (error === 'password.not_matched') {
                error = 'password.not_matched_2fa';
            }

            if (error === 'captcha.required') {
                magicService.stop();
                dispatch(setCaptchaTrack(magicService.trackId));
                dispatch(changeCaptchaState(true));
                return;
            }

            if (error === 'track.not_found') {
                // TODO: убрать костыль для PASSP-21000
                if (magicService.trackNotFoundErrorCount > 5) {
                    magicService.stop();
                    dispatch(setMagicError(error));
                    dispatch(reAuthPasswordSubmit());
                }

                magicService.trackNotFoundErrorCount++;
            }

            if (['internal.temporary', 'backend.redis_failed', 'track.not_found'].indexOf(error) === -1) {
                magicService.stop();
                dispatch(setMagicError(error));
                dispatch(reAuthPasswordSubmit());
            }
        }

        magicService.restartPolling();
    };
}
