import {magicService} from '@blocks/AuthSilent/magicService';
import {magicDoneCallback} from './magicDoneCallback';
import {magicFailCallback} from './magicFailCallback';

export function magicInit() {
    return (dispatch, getState) => {
        const {
            auth: {magicTrack: trackId, magicCSRF: csrfToken}
        } = getState();

        magicService.init({
            doneCallback: magicDoneCallback,
            failCallback: magicFailCallback(dispatch),
            trackId,
            csrfToken
        });
        magicService.start();
    };
}
