import api from '../../../api';
import {setAuthMessengerError, setAuthMessengerSent} from './';
import {changePagePopupType, changePagePopupVisibility, domikIsLoading, setPasswordError} from '../';
import {
    AUTH_MESSENGER_SEND_CODE_SUCCESS,
    AUTH_MESSENGER_SEND_CODE_FAIL,
    CLICK_AUTH_MESSENGER_BUTTON
} from '../../metrics_constants';
import metrics from '../../../metrics';

export default function sendRequestToMessenger() {
    metrics.send([CLICK_AUTH_MESSENGER_BUTTON]);
    return (dispatch, getState) => {
        const {
            common: {csrf, track_id},
            settings: {language}
        } = getState();

        const params = {
            csrf_token: csrf,
            language: language,
            send_to: 'messenger',
            track_id
        };

        dispatch(domikIsLoading(true));

        api.request('auth/send_magic_letter', params)
            .done((response = {}) => {
                if (response && response.status === 'ok') {
                    const {code} = response;

                    dispatch(setAuthMessengerSent(code));
                    dispatch(changePagePopupVisibility(true));
                    dispatch(changePagePopupType('authMessenger'));
                    metrics.send([AUTH_MESSENGER_SEND_CODE_SUCCESS]);
                } else {
                    dispatch(setAuthMessengerError('global'));
                }
            })
            .fail((response) => {
                const errorCode = Array.isArray(response.errors) ? response.errors[0] : 'global';

                if (errorCode === 'bot_api.request_failed') {
                    dispatch(changePagePopupVisibility(true));
                    dispatch(changePagePopupType('authMessengerInfo'));
                    dispatch(setPasswordError(''));
                    return;
                }

                dispatch(setAuthMessengerError(errorCode));
                metrics.send([AUTH_MESSENGER_SEND_CODE_FAIL, errorCode]);
            })
            .always(() => {
                dispatch(domikIsLoading(false));
            });
    };
}
