import api from '@blocks/api';
import {domikIsLoading, changeCaptchaState} from './';
import reloadCaptcha from '@components/Captcha/actions/reloadCaptcha';
import {getRedirectUrl} from '@blocks/selectors';
import {amSetAnalyticsToRetpath} from '@blocks/authv2/actions/nativeMobileApi';

export default function multiStepAuthCommitMagic() {
    return (dispatch, getState) => {
        const state = getState();
        const {
            common: {track_id: trackId, csrf},
            am = {}
        } = state;
        const params = {
            track_id: trackId,
            csrf_token: csrf
        };

        let redirectUrl = getRedirectUrl(state);

        if (am.isAm) {
            dispatch(amSetAnalyticsToRetpath('magic_link_auth'));
            redirectUrl = getRedirectUrl(getState());
        }

        dispatch(domikIsLoading(true));

        api.request('auth/multi_step/commit_magic', params)
            .done((response) => {
                if (am.isAm) {
                    dispatch(domikIsLoading(false));
                }

                if (response.status === 'ok') {
                    window.location = redirectUrl;
                    return;
                }
            })
            .fail((result) => {
                const error = result && result.errors[0];

                if (!error) {
                    return;
                }

                const {
                    auth: {isCaptchaRequired}
                } = getState();

                if (['captcha.required', 'captcha.invalid'].indexOf(error) > -1) {
                    dispatch(changeCaptchaState(true));

                    if (isCaptchaRequired) {
                        dispatch(reloadCaptcha());
                    }
                }
            })
            .always(() => {
                dispatch(domikIsLoading(false));
            });
    };
}
