import filter from 'lodash/filter';
import {
    changeProcessedAccount,
    updateTokensSuccess,
    domikIsLoading,
    canRegister,
    setupBackPane,
    setLoginError,
    setLoginAbleToRestore,
    updateLoginValue,
    setupMode
} from './';
import switchToModeWelcome from './switchToModeWelcome';
import switchToModeMagic from './switchToModeMagic';
import switchToModeAddingAccount from './switchToModeAddingAccount';
import switchToModeRegisterLite from './switchToModeRegisterLite';
import redirectToRegistration from './redirectToRegistration';
import {redirectToSAML} from './redirectToSAML';
import {switchToModeRestoreLoginWithPhone} from './switchToModeRestoreLoginWithPhone';
import {switchToModeRegisterWithPhone} from './switchToModeRegisterWithPhone';
import {
    SHOW_LOGIN_FORM,
    SEND_LOGIN_FORM,
    SEND_LOGIN_FORM_SUCCESS,
    SEND_LOGIN_FORM_ERROR,
    SEND_LOGIN_FORM_CAN_REGISTER
} from '@blocks/authv2/metrics_constants';
import {hasExp, isNeoPhonishRegisterAvailable} from '@blocks/selectors';
import metrics from '@blocks/metrics';
import api from '@blocks/api';
import {redirectToExternalUrl} from '@blocks/utils';
import {ACCOUNT_TYPES, getAccountTypeByAlias} from '@blocks/authv2/utils/accountTypes';
import {
    ENTRY_REGISTER_ROUTE,
    ENTRY_REGISTER_PROCESS,
    ENTRY_RESTORE_NEOPHONISH_PROCESS,
    SCENARIO_TYPE_AUTH
} from '@blocks/UserEntryFlow/processes';
import {checkFioStepIsRequired, initWithPhoneConfirmation} from '@blocks/UserEntryFlow/logic';
import {RegType} from '@blocks/authv2/nativeMobileApi/constants';
import {amDeletedAccountAuth} from '@blocks/authv2/actions/nativeMobileApi';
import {updatePhoneStatus} from '@blocks/authv2/actions/forcePasswordChange';

const YANDEX_TEAM_REGEX = /^[^@]*@yandex-team.ru$/gim;
const YANDEX_TEAM_URL = 'https://passport.yandex-team.ru';

let amAutoswitched = false;

export const switchToLogin = (login, callback, oldTrackId) => (dispatch) => {
    // ААААААААА!!!!!! （╯°□°）╯ ┻━┻
    dispatch(setupMode(''));
    dispatch(multiStepAuthStart({login}, callback, oldTrackId));
};

export default function multiStepAuthStart(
    {login, backPane = '', isRegister = false, isAuthFromSocialSuggest = false},
    callback,
    oldTrackId
) {
    return (dispatch, getState) => {
        const state = getState();
        const {socialSuggest = {}, am = {}, router: {location = {}} = {}} = state;
        const {isAm, appId, initialData = {}, regType = '', mode} = am;
        const {search} = location;
        const {authTrackId, processUUID: socialProcessUUID} = socialSuggest;
        const isNeoPhonishRegister = isNeoPhonishRegisterAvailable(state);
        const useNewSuggestByPhone = hasExp(state, 'use-new-suggest-by-phone') || regType === RegType.DOREGISH;

        dispatch(domikIsLoading(true));
        dispatch(setLoginAbleToRestore(false));

        const {
            common: {csrf, retpath, fretpath, origin, from: service},
            auth: {
                process_uuid: processUUID,
                form: {pdd_domain: pddDomain},
                loginFieldType
            }
        } = state;

        let params = {
            csrf_token: csrf,
            login
        };

        if (processUUID) {
            params.process_uuid = processUUID;
        }

        if (retpath) {
            params.retpath = retpath;
        }

        if (fretpath) {
            params.fretpath = fretpath;
        }

        if (origin) {
            params.origin = origin;
        }

        if (service) {
            params.service = service;
        }

        if (pddDomain && login && !/@/.test(login)) {
            params.login = `${params.login}@${pddDomain}`;
        }

        if (pddDomain) {
            params.is_pdd = '1';
        }

        if (isAuthFromSocialSuggest) {
            params.social_track_id = authTrackId;
            params.process_uuid = socialProcessUUID;
        }

        if (isAm && appId) {
            params.isAm = isAm;
            params.appId = appId;
            params = Object.assign({}, params, initialData);
        }

        if (oldTrackId) {
            params.old_track_id = oldTrackId;
            dispatch(updatePhoneStatus('phone-confirmed'));
        }

        if (loginFieldType !== 'phone') {
            dispatch(updateLoginValue(login));
        }

        if (isAm && YANDEX_TEAM_REGEX.test(login)) {
            return redirectToExternalUrl({
                urlString: `${YANDEX_TEAM_URL}/auth`,
                queryObj: {
                    login,
                    retpath: `${YANDEX_TEAM_URL}/am/finish?status=ok`
                }
            });
        }

        api.request('auth/multi_step/start', params)
            .done((response = {}) => {
                const {
                    allowed_account_types: allowedAccountTypes = [],
                    phone_number: phoneNumber,
                    primary_alias_type: primaryAliasType,
                    samlSsoUrl,
                    country,
                    track_id
                } = response;
                // phoneNumber может быть null и не получится фолбэка на {}
                const international = phoneNumber && phoneNumber.international;

                if (samlSsoUrl) {
                    dispatch(redirectToSAML({samlSsoUrl}));
                    return;
                }

                if (response.can_register && isAm && mode === 'turbo' && typeof callback === 'function') {
                    return callback({isShortCircuit: true});
                }

                if (useNewSuggestByPhone && phoneNumber && country) {
                    dispatch(updateTokensSuccess(track_id, csrf));
                    dispatch(checkFioStepIsRequired(phoneNumber.original, SCENARIO_TYPE_AUTH));
                    dispatch(
                        initWithPhoneConfirmation({
                            phone: phoneNumber.original,
                            route: `${ENTRY_REGISTER_ROUTE}${search}`,
                            processName: ENTRY_REGISTER_PROCESS,
                            isRegAfterAuthStart: true
                        })
                    );
                    metrics.send(['Переход на флоу регистрации или авторизации через саджест']);
                    return;
                }

                if (response.can_register) {
                    if (international && allowedAccountTypes.includes(ACCOUNT_TYPES.NEOPHONISH)) {
                        if (isNeoPhonishRegister) {
                            metrics.send(['Переход на флоу регистрации неофониша']);
                            return dispatch(switchToModeRegisterWithPhone(international));
                        }

                        if (hasExp(state, 'domik-phone-autostart-on')) {
                            metrics.send(['Переход на флоу восстановления неофониша']);
                            return dispatch(
                                switchToModeRestoreLoginWithPhone({
                                    phone: international,
                                    processName: ENTRY_RESTORE_NEOPHONISH_PROCESS
                                })
                            );
                        }
                    }

                    if (!(isAm && !isRegister)) {
                        dispatch(
                            canRegister({
                                isCanRegister: true,
                                registrationLogin: response.login || login,
                                registrationType: response.account_type || 'portal',
                                registrationPhoneNumber:
                                    (response.phone_number && response.phone_number.original) || '',
                                registrationCountry: response.country || ''
                            })
                        );
                    }

                    dispatch(domikIsLoading(false));

                    if (response.account_type === 'lite') {
                        dispatch(switchToModeRegisterLite());
                        return;
                    }

                    if (isRegister) {
                        dispatch(redirectToRegistration());
                        return;
                    }

                    dispatch(setLoginError('login.can_register'));

                    metrics.send([SHOW_LOGIN_FORM, SEND_LOGIN_FORM, SEND_LOGIN_FORM_CAN_REGISTER]);

                    if (getState().auth.mode === 'magic') {
                        dispatch(switchToModeAddingAccount());
                    }

                    return;
                }

                dispatch(canRegister({isCanRegister: false}));

                metrics.send([SHOW_LOGIN_FORM, SEND_LOGIN_FORM, SEND_LOGIN_FORM_SUCCESS]);

                const {
                    auth_methods: authMethods,
                    preferred_auth_method: preferredAuthMethod,
                    track_id: trackId,
                    csrf_token: magicCSRF,
                    magic_link_email: email
                } = response;
                const {
                    auth: {
                        unitedAccounts,
                        form: {isForceOTP},
                        isQRAuthEnabled
                    },
                    settings: {ua}
                } = getState();

                let processedAccount = filter(unitedAccounts, (account) => account.login === login)[0];

                if (!processedAccount) {
                    processedAccount = {
                        isAddedAccount: true,
                        allowed_auth_methods: authMethods,
                        preferred_auth_method: authMethods[0] || 'password',
                        avatarId: '0/0-0',
                        email,
                        login,
                        phone: international
                    };
                } else {
                    processedAccount = Object.assign({}, processedAccount, {
                        allowed_auth_methods: processedAccount.allowed_auth_methods || authMethods || [],
                        preferred_auth_method:
                            processedAccount.preferred_auth_method ||
                            preferredAuthMethod ||
                            (authMethods && authMethods[0]) ||
                            'password',
                        email,
                        phone: international
                    });
                }

                if (backPane) {
                    dispatch(setupBackPane(backPane));
                }

                const authMethod = processedAccount.preferred_auth_method;

                // Если выключен эксперимент на авторизацию по QR-коду, но пришел метод авторизации magic_x_token, то
                // необходимо выбрать следующий достуный способ авторизации.
                // И на всякий случай сделать fallback на авторизацию по паролю
                // TODO: убрать, когда эксперимент выкатим на 100%
                if (authMethod === 'magic_x_token' && !isQRAuthEnabled) {
                    const allowedAuthMethods = processedAccount.allowed_auth_methods;

                    processedAccount.preferred_auth_method =
                        allowedAuthMethods.filter((method) => method !== 'magic_x_token')[0] || 'password';
                }

                processedAccount.primaryAliasType = primaryAliasType;

                dispatch(changeProcessedAccount(processedAccount));
                dispatch(updateTokensSuccess(trackId, magicCSRF));

                const isQrAuthMethod = authMethod === 'magic' || (authMethod === 'magic_x_token' && isQRAuthEnabled);
                const isTouch = ua && ua.isTouch;

                if (isQrAuthMethod && !isForceOTP && !isTouch) {
                    dispatch(switchToModeMagic(true));
                    return;
                }

                dispatch(switchToModeWelcome());

                if (callback && typeof callback === 'function') {
                    callback({isShortCircuit: false});
                }
            })
            .fail((result = {}) => {
                const {
                    phone_number: phoneNumber,
                    errors = [],
                    primary_alias_type: primaryAliasType,
                    track_id,
                    country
                } = result;
                // phoneNumber может быть null и не получится фолбэка на {}
                const international = phoneNumber && phoneNumber.international;

                const error = errors[0];

                if (isAm && mode === 'turbo' && typeof callback === 'function') {
                    return callback({isShortCircuit: true});
                }

                if (error === 'action.impossible' || error === 'account.disabled_on_deletion') {
                    if (useNewSuggestByPhone && phoneNumber && country) {
                        dispatch(updateTokensSuccess(track_id, csrf));
                        dispatch(checkFioStepIsRequired(phoneNumber.original, SCENARIO_TYPE_AUTH));
                        dispatch(
                            initWithPhoneConfirmation({
                                phone: phoneNumber.original,
                                route: `${ENTRY_REGISTER_ROUTE}${search}`,
                                processName: ENTRY_REGISTER_PROCESS,
                                isRegAfterAuthStart: true
                            })
                        );
                        metrics.send(['Переход на флоу регистрации или авторизации через саджест']);
                        return;
                    }

                    // Go to restore neophonish
                    if (getAccountTypeByAlias(primaryAliasType) === ACCOUNT_TYPES.NEOPHONISH) {
                        return dispatch(
                            switchToModeRestoreLoginWithPhone({
                                phone: international,
                                processName: ENTRY_RESTORE_NEOPHONISH_PROCESS
                            })
                        );
                    }
                }

                if (isAm && (error === 'account.disabled_on_deletion' || error === 'login.notavailable')) {
                    dispatch(amDeletedAccountAuth());
                }

                metrics.send([SHOW_LOGIN_FORM, SEND_LOGIN_FORM, SEND_LOGIN_FORM_ERROR, error]);

                dispatch(setLoginError(error));
                dispatch(canRegister({isCanRegister: false}));

                if (result.can_be_restored) {
                    dispatch(setLoginAbleToRestore(true));
                }

                if (isRegister) {
                    return;
                }

                dispatch(switchToModeAddingAccount());
            })
            .always(() => {
                dispatch(domikIsLoading(false));
            });
    };
}

export function amOnLoginFormMount() {
    return (dispatch, getState) => {
        const {am: {isAm, mode, login} = {}} = getState();

        if (isAm && mode === 'relogin' && login && !amAutoswitched) {
            amAutoswitched = true;

            dispatch(switchToLogin(login));

            return;
        }
    };
}
